/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Provides detailed information about a process executed by a command step.")
public class ApiCommandStepProcess {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="id")
    private BigDecimal id = null;
    @SerializedName(value="program")
    private String program = null;
    @SerializedName(value="args")
    private String args = null;
    @SerializedName(value="stdout")
    private String stdout = null;
    @SerializedName(value="stderr")
    private String stderr = null;
    @SerializedName(value="exitCode")
    private BigDecimal exitCode = null;

    public ApiCommandStepProcess name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the command step process.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiCommandStepProcess id(BigDecimal id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="Id of the command step process.")
    public BigDecimal getId() {
        return this.id;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    public ApiCommandStepProcess program(String program) {
        this.program = program;
        return this;
    }

    @ApiModelProperty(value="The executed program command.")
    public String getProgram() {
        return this.program;
    }

    public void setProgram(String program) {
        this.program = program;
    }

    public ApiCommandStepProcess args(String args) {
        this.args = args;
        return this;
    }

    @ApiModelProperty(value="JSON-encoded list of program arguments.")
    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public ApiCommandStepProcess stdout(String stdout) {
        this.stdout = stdout;
        return this;
    }

    @ApiModelProperty(value="Last lines of the executed program's standard output.")
    public String getStdout() {
        return this.stdout;
    }

    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    public ApiCommandStepProcess stderr(String stderr) {
        this.stderr = stderr;
        return this;
    }

    @ApiModelProperty(value="Last lines of the executed program's standard error.")
    public String getStderr() {
        return this.stderr;
    }

    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    public ApiCommandStepProcess exitCode(BigDecimal exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    @ApiModelProperty(value="The executed program's exit code.")
    public BigDecimal getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(BigDecimal exitCode) {
        this.exitCode = exitCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCommandStepProcess apiCommandStepProcess = (ApiCommandStepProcess)o;
        return Objects.equals(this.name, apiCommandStepProcess.name) && Objects.equals(this.id, apiCommandStepProcess.id) && Objects.equals(this.program, apiCommandStepProcess.program) && Objects.equals(this.args, apiCommandStepProcess.args) && Objects.equals(this.stdout, apiCommandStepProcess.stdout) && Objects.equals(this.stderr, apiCommandStepProcess.stderr) && Objects.equals(this.exitCode, apiCommandStepProcess.exitCode);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.program, this.args, this.stdout, this.stderr, this.exitCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCommandStepProcess {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    program: ").append(this.toIndentedString(this.program)).append("\n");
        sb.append("    args: ").append(this.toIndentedString(this.args)).append("\n");
        sb.append("    stdout: ").append(this.toIndentedString(this.stdout)).append("\n");
        sb.append("    stderr: ").append(this.toIndentedString(this.stderr)).append("\n");
        sb.append("    exitCode: ").append(this.toIndentedString(this.exitCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

