/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHdfsReplicationCounter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Detailed information about an OZONE replication job.")
public class ApiOzoneReplicationResult {
    @SerializedName(value="progress")
    private BigDecimal progress = null;
    @SerializedName(value="throughput")
    private BigDecimal throughput = null;
    @SerializedName(value="remainingTime")
    private BigDecimal remainingTime = null;
    @SerializedName(value="estimatedCompletionTime")
    private String estimatedCompletionTime = null;
    @SerializedName(value="counters")
    private List<ApiHdfsReplicationCounter> counters = null;
    @SerializedName(value="numFilesDryRun")
    private BigDecimal numFilesDryRun = null;
    @SerializedName(value="numBytesDryRun")
    private BigDecimal numBytesDryRun = null;
    @SerializedName(value="numFilesExpected")
    private BigDecimal numFilesExpected = null;
    @SerializedName(value="numBytesExpected")
    private BigDecimal numBytesExpected = null;
    @SerializedName(value="numFilesCopied")
    private BigDecimal numFilesCopied = null;
    @SerializedName(value="numBytesCopied")
    private BigDecimal numBytesCopied = null;
    @SerializedName(value="numFilesSkipped")
    private BigDecimal numFilesSkipped = null;
    @SerializedName(value="numBytesSkipped")
    private BigDecimal numBytesSkipped = null;
    @SerializedName(value="numFilesDeleted")
    private BigDecimal numFilesDeleted = null;
    @SerializedName(value="numFilesCopyFailed")
    private BigDecimal numFilesCopyFailed = null;
    @SerializedName(value="numBytesCopyFailed")
    private BigDecimal numBytesCopyFailed = null;
    @SerializedName(value="setupError")
    private String setupError = null;
    @SerializedName(value="jobId")
    private String jobId = null;
    @SerializedName(value="jobDetailsUri")
    private String jobDetailsUri = null;
    @SerializedName(value="dryRun")
    private Boolean dryRun = null;
    @SerializedName(value="snapshottedDirs")
    private List<String> snapshottedDirs = null;
    @SerializedName(value="runAsUser")
    private String runAsUser = null;
    @SerializedName(value="runOnSourceAsUser")
    private String runOnSourceAsUser = null;
    @SerializedName(value="logPath")
    private String logPath = null;
    @SerializedName(value="failedFiles")
    private List<String> failedFiles = null;

    public ApiOzoneReplicationResult progress(BigDecimal progress) {
        this.progress = progress;
        return this;
    }

    @ApiModelProperty(value="The file copy progress percentage.")
    public BigDecimal getProgress() {
        return this.progress;
    }

    public void setProgress(BigDecimal progress) {
        this.progress = progress;
    }

    public ApiOzoneReplicationResult throughput(BigDecimal throughput) {
        this.throughput = throughput;
        return this;
    }

    @ApiModelProperty(value="The data throughput in KB/s.")
    public BigDecimal getThroughput() {
        return this.throughput;
    }

    public void setThroughput(BigDecimal throughput) {
        this.throughput = throughput;
    }

    public ApiOzoneReplicationResult remainingTime(BigDecimal remainingTime) {
        this.remainingTime = remainingTime;
        return this;
    }

    @ApiModelProperty(value="The time remaining for mapper phase (seconds).")
    public BigDecimal getRemainingTime() {
        return this.remainingTime;
    }

    public void setRemainingTime(BigDecimal remainingTime) {
        this.remainingTime = remainingTime;
    }

    public ApiOzoneReplicationResult estimatedCompletionTime(String estimatedCompletionTime) {
        this.estimatedCompletionTime = estimatedCompletionTime;
        return this;
    }

    @ApiModelProperty(value="The estimated completion time for the mapper phase.")
    public String getEstimatedCompletionTime() {
        return this.estimatedCompletionTime;
    }

    public void setEstimatedCompletionTime(String estimatedCompletionTime) {
        this.estimatedCompletionTime = estimatedCompletionTime;
    }

    public ApiOzoneReplicationResult counters(List<ApiHdfsReplicationCounter> counters) {
        this.counters = counters;
        return this;
    }

    public ApiOzoneReplicationResult addCountersItem(ApiHdfsReplicationCounter countersItem) {
        if (this.counters == null) {
            this.counters = new ArrayList<ApiHdfsReplicationCounter>();
        }
        this.counters.add(countersItem);
        return this;
    }

    @ApiModelProperty(value="The counters collected from the replication job. <p/> Starting with API v4, the full list of counters is only available in the full view.")
    public List<ApiHdfsReplicationCounter> getCounters() {
        return this.counters;
    }

    public void setCounters(List<ApiHdfsReplicationCounter> counters) {
        this.counters = counters;
    }

    public ApiOzoneReplicationResult numFilesDryRun(BigDecimal numFilesDryRun) {
        this.numFilesDryRun = numFilesDryRun;
        return this;
    }

    @ApiModelProperty(value="The number of files found to copy.")
    public BigDecimal getNumFilesDryRun() {
        return this.numFilesDryRun;
    }

    public void setNumFilesDryRun(BigDecimal numFilesDryRun) {
        this.numFilesDryRun = numFilesDryRun;
    }

    public ApiOzoneReplicationResult numBytesDryRun(BigDecimal numBytesDryRun) {
        this.numBytesDryRun = numBytesDryRun;
        return this;
    }

    @ApiModelProperty(value="The number of bytes found to copy.")
    public BigDecimal getNumBytesDryRun() {
        return this.numBytesDryRun;
    }

    public void setNumBytesDryRun(BigDecimal numBytesDryRun) {
        this.numBytesDryRun = numBytesDryRun;
    }

    public ApiOzoneReplicationResult numFilesExpected(BigDecimal numFilesExpected) {
        this.numFilesExpected = numFilesExpected;
        return this;
    }

    @ApiModelProperty(value="The number of files expected to be copied.")
    public BigDecimal getNumFilesExpected() {
        return this.numFilesExpected;
    }

    public void setNumFilesExpected(BigDecimal numFilesExpected) {
        this.numFilesExpected = numFilesExpected;
    }

    public ApiOzoneReplicationResult numBytesExpected(BigDecimal numBytesExpected) {
        this.numBytesExpected = numBytesExpected;
        return this;
    }

    @ApiModelProperty(value="The number of bytes expected to be copied.")
    public BigDecimal getNumBytesExpected() {
        return this.numBytesExpected;
    }

    public void setNumBytesExpected(BigDecimal numBytesExpected) {
        this.numBytesExpected = numBytesExpected;
    }

    public ApiOzoneReplicationResult numFilesCopied(BigDecimal numFilesCopied) {
        this.numFilesCopied = numFilesCopied;
        return this;
    }

    @ApiModelProperty(value="The number of files actually copied.")
    public BigDecimal getNumFilesCopied() {
        return this.numFilesCopied;
    }

    public void setNumFilesCopied(BigDecimal numFilesCopied) {
        this.numFilesCopied = numFilesCopied;
    }

    public ApiOzoneReplicationResult numBytesCopied(BigDecimal numBytesCopied) {
        this.numBytesCopied = numBytesCopied;
        return this;
    }

    @ApiModelProperty(value="The number of bytes actually copied.")
    public BigDecimal getNumBytesCopied() {
        return this.numBytesCopied;
    }

    public void setNumBytesCopied(BigDecimal numBytesCopied) {
        this.numBytesCopied = numBytesCopied;
    }

    public ApiOzoneReplicationResult numFilesSkipped(BigDecimal numFilesSkipped) {
        this.numFilesSkipped = numFilesSkipped;
        return this;
    }

    @ApiModelProperty(value="The number of files that were unchanged and thus skipped during copying.")
    public BigDecimal getNumFilesSkipped() {
        return this.numFilesSkipped;
    }

    public void setNumFilesSkipped(BigDecimal numFilesSkipped) {
        this.numFilesSkipped = numFilesSkipped;
    }

    public ApiOzoneReplicationResult numBytesSkipped(BigDecimal numBytesSkipped) {
        this.numBytesSkipped = numBytesSkipped;
        return this;
    }

    @ApiModelProperty(value="The aggregate number of bytes in the skipped files.")
    public BigDecimal getNumBytesSkipped() {
        return this.numBytesSkipped;
    }

    public void setNumBytesSkipped(BigDecimal numBytesSkipped) {
        this.numBytesSkipped = numBytesSkipped;
    }

    public ApiOzoneReplicationResult numFilesDeleted(BigDecimal numFilesDeleted) {
        this.numFilesDeleted = numFilesDeleted;
        return this;
    }

    @ApiModelProperty(value="The number of files deleted since they were present at destination, but missing from source.")
    public BigDecimal getNumFilesDeleted() {
        return this.numFilesDeleted;
    }

    public void setNumFilesDeleted(BigDecimal numFilesDeleted) {
        this.numFilesDeleted = numFilesDeleted;
    }

    public ApiOzoneReplicationResult numFilesCopyFailed(BigDecimal numFilesCopyFailed) {
        this.numFilesCopyFailed = numFilesCopyFailed;
        return this;
    }

    @ApiModelProperty(value="The number of files for which copy failed.")
    public BigDecimal getNumFilesCopyFailed() {
        return this.numFilesCopyFailed;
    }

    public void setNumFilesCopyFailed(BigDecimal numFilesCopyFailed) {
        this.numFilesCopyFailed = numFilesCopyFailed;
    }

    public ApiOzoneReplicationResult numBytesCopyFailed(BigDecimal numBytesCopyFailed) {
        this.numBytesCopyFailed = numBytesCopyFailed;
        return this;
    }

    @ApiModelProperty(value="The aggregate number of bytes in the files for which copy failed.")
    public BigDecimal getNumBytesCopyFailed() {
        return this.numBytesCopyFailed;
    }

    public void setNumBytesCopyFailed(BigDecimal numBytesCopyFailed) {
        this.numBytesCopyFailed = numBytesCopyFailed;
    }

    public ApiOzoneReplicationResult setupError(String setupError) {
        this.setupError = setupError;
        return this;
    }

    @ApiModelProperty(value="The error that happened during job setup, if any.")
    public String getSetupError() {
        return this.setupError;
    }

    public void setSetupError(String setupError) {
        this.setupError = setupError;
    }

    public ApiOzoneReplicationResult jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @ApiModelProperty(value="Read-only. The MapReduce job ID for the replication job. Available since API v4. <p/> This can be used to query information about the replication job from the MapReduce server where it was executed. Refer to the \"/activities\" resource for services for further details.")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public ApiOzoneReplicationResult jobDetailsUri(String jobDetailsUri) {
        this.jobDetailsUri = jobDetailsUri;
        return this;
    }

    @ApiModelProperty(value="Read-only. The URI (relative to the CM server's root) where to find the Activity Monitor page for the job. Available since API v4.")
    public String getJobDetailsUri() {
        return this.jobDetailsUri;
    }

    public void setJobDetailsUri(String jobDetailsUri) {
        this.jobDetailsUri = jobDetailsUri;
    }

    public ApiOzoneReplicationResult dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @ApiModelProperty(value="Whether this was a dry run.")
    public Boolean getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ApiOzoneReplicationResult snapshottedDirs(List<String> snapshottedDirs) {
        this.snapshottedDirs = snapshottedDirs;
        return this;
    }

    public ApiOzoneReplicationResult addSnapshottedDirsItem(String snapshottedDirsItem) {
        if (this.snapshottedDirs == null) {
            this.snapshottedDirs = new ArrayList<String>();
        }
        this.snapshottedDirs.add(snapshottedDirsItem);
        return this;
    }

    @ApiModelProperty(value="The list of directories for which snapshots were taken and used as part of this replication.")
    public List<String> getSnapshottedDirs() {
        return this.snapshottedDirs;
    }

    public void setSnapshottedDirs(List<String> snapshottedDirs) {
        this.snapshottedDirs = snapshottedDirs;
    }

    public ApiOzoneReplicationResult runAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    @ApiModelProperty(value="Returns run-as user name. Available since API v11.")
    public String getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
    }

    public ApiOzoneReplicationResult runOnSourceAsUser(String runOnSourceAsUser) {
        this.runOnSourceAsUser = runOnSourceAsUser;
        return this;
    }

    @ApiModelProperty(value="Returns run-as user name for source cluster. Available since API v18.")
    public String getRunOnSourceAsUser() {
        return this.runOnSourceAsUser;
    }

    public void setRunOnSourceAsUser(String runOnSourceAsUser) {
        this.runOnSourceAsUser = runOnSourceAsUser;
    }

    public ApiOzoneReplicationResult logPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    @ApiModelProperty(value="Returns HDFS path of DistCp execution log files. Available since API v33.")
    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public ApiOzoneReplicationResult failedFiles(List<String> failedFiles) {
        this.failedFiles = failedFiles;
        return this;
    }

    public ApiOzoneReplicationResult addFailedFilesItem(String failedFilesItem) {
        if (this.failedFiles == null) {
            this.failedFiles = new ArrayList<String>();
        }
        this.failedFiles.add(failedFilesItem);
        return this;
    }

    @ApiModelProperty(value="The list of files that failed during replication. Available since API v11.")
    public List<String> getFailedFiles() {
        return this.failedFiles;
    }

    public void setFailedFiles(List<String> failedFiles) {
        this.failedFiles = failedFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiOzoneReplicationResult apiOzoneReplicationResult = (ApiOzoneReplicationResult)o;
        return Objects.equals(this.progress, apiOzoneReplicationResult.progress) && Objects.equals(this.throughput, apiOzoneReplicationResult.throughput) && Objects.equals(this.remainingTime, apiOzoneReplicationResult.remainingTime) && Objects.equals(this.estimatedCompletionTime, apiOzoneReplicationResult.estimatedCompletionTime) && Objects.equals(this.counters, apiOzoneReplicationResult.counters) && Objects.equals(this.numFilesDryRun, apiOzoneReplicationResult.numFilesDryRun) && Objects.equals(this.numBytesDryRun, apiOzoneReplicationResult.numBytesDryRun) && Objects.equals(this.numFilesExpected, apiOzoneReplicationResult.numFilesExpected) && Objects.equals(this.numBytesExpected, apiOzoneReplicationResult.numBytesExpected) && Objects.equals(this.numFilesCopied, apiOzoneReplicationResult.numFilesCopied) && Objects.equals(this.numBytesCopied, apiOzoneReplicationResult.numBytesCopied) && Objects.equals(this.numFilesSkipped, apiOzoneReplicationResult.numFilesSkipped) && Objects.equals(this.numBytesSkipped, apiOzoneReplicationResult.numBytesSkipped) && Objects.equals(this.numFilesDeleted, apiOzoneReplicationResult.numFilesDeleted) && Objects.equals(this.numFilesCopyFailed, apiOzoneReplicationResult.numFilesCopyFailed) && Objects.equals(this.numBytesCopyFailed, apiOzoneReplicationResult.numBytesCopyFailed) && Objects.equals(this.setupError, apiOzoneReplicationResult.setupError) && Objects.equals(this.jobId, apiOzoneReplicationResult.jobId) && Objects.equals(this.jobDetailsUri, apiOzoneReplicationResult.jobDetailsUri) && Objects.equals(this.dryRun, apiOzoneReplicationResult.dryRun) && Objects.equals(this.snapshottedDirs, apiOzoneReplicationResult.snapshottedDirs) && Objects.equals(this.runAsUser, apiOzoneReplicationResult.runAsUser) && Objects.equals(this.runOnSourceAsUser, apiOzoneReplicationResult.runOnSourceAsUser) && Objects.equals(this.logPath, apiOzoneReplicationResult.logPath) && Objects.equals(this.failedFiles, apiOzoneReplicationResult.failedFiles);
    }

    public int hashCode() {
        return Objects.hash(this.progress, this.throughput, this.remainingTime, this.estimatedCompletionTime, this.counters, this.numFilesDryRun, this.numBytesDryRun, this.numFilesExpected, this.numBytesExpected, this.numFilesCopied, this.numBytesCopied, this.numFilesSkipped, this.numBytesSkipped, this.numFilesDeleted, this.numFilesCopyFailed, this.numBytesCopyFailed, this.setupError, this.jobId, this.jobDetailsUri, this.dryRun, this.snapshottedDirs, this.runAsUser, this.runOnSourceAsUser, this.logPath, this.failedFiles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiOzoneReplicationResult {\n");
        sb.append("    progress: ").append(this.toIndentedString(this.progress)).append("\n");
        sb.append("    throughput: ").append(this.toIndentedString(this.throughput)).append("\n");
        sb.append("    remainingTime: ").append(this.toIndentedString(this.remainingTime)).append("\n");
        sb.append("    estimatedCompletionTime: ").append(this.toIndentedString(this.estimatedCompletionTime)).append("\n");
        sb.append("    counters: ").append(this.toIndentedString(this.counters)).append("\n");
        sb.append("    numFilesDryRun: ").append(this.toIndentedString(this.numFilesDryRun)).append("\n");
        sb.append("    numBytesDryRun: ").append(this.toIndentedString(this.numBytesDryRun)).append("\n");
        sb.append("    numFilesExpected: ").append(this.toIndentedString(this.numFilesExpected)).append("\n");
        sb.append("    numBytesExpected: ").append(this.toIndentedString(this.numBytesExpected)).append("\n");
        sb.append("    numFilesCopied: ").append(this.toIndentedString(this.numFilesCopied)).append("\n");
        sb.append("    numBytesCopied: ").append(this.toIndentedString(this.numBytesCopied)).append("\n");
        sb.append("    numFilesSkipped: ").append(this.toIndentedString(this.numFilesSkipped)).append("\n");
        sb.append("    numBytesSkipped: ").append(this.toIndentedString(this.numBytesSkipped)).append("\n");
        sb.append("    numFilesDeleted: ").append(this.toIndentedString(this.numFilesDeleted)).append("\n");
        sb.append("    numFilesCopyFailed: ").append(this.toIndentedString(this.numFilesCopyFailed)).append("\n");
        sb.append("    numBytesCopyFailed: ").append(this.toIndentedString(this.numBytesCopyFailed)).append("\n");
        sb.append("    setupError: ").append(this.toIndentedString(this.setupError)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    jobDetailsUri: ").append(this.toIndentedString(this.jobDetailsUri)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    snapshottedDirs: ").append(this.toIndentedString(this.snapshottedDirs)).append("\n");
        sb.append("    runAsUser: ").append(this.toIndentedString(this.runAsUser)).append("\n");
        sb.append("    runOnSourceAsUser: ").append(this.toIndentedString(this.runOnSourceAsUser)).append("\n");
        sb.append("    logPath: ").append(this.toIndentedString(this.logPath)).append("\n");
        sb.append("    failedFiles: ").append(this.toIndentedString(this.failedFiles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

