/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Describe a time series entity type and attributes associated with this entity type. <p> Available since API v11.")
public class ApiTimeSeriesEntityType {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="category")
    private String category = null;
    @SerializedName(value="nameForCrossEntityAggregateMetrics")
    private String nameForCrossEntityAggregateMetrics = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="immutableAttributeNames")
    private List<String> immutableAttributeNames = null;
    @SerializedName(value="mutableAttributeNames")
    private List<String> mutableAttributeNames = null;
    @SerializedName(value="entityNameFormat")
    private List<String> entityNameFormat = null;
    @SerializedName(value="entityDisplayNameFormat")
    private String entityDisplayNameFormat = null;
    @SerializedName(value="parentMetricEntityTypeNames")
    private List<String> parentMetricEntityTypeNames = null;

    public ApiTimeSeriesEntityType name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Returns the name of the entity type. This name uniquely identifies this entity type.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiTimeSeriesEntityType category(String category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="Returns the category of the entity type.")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ApiTimeSeriesEntityType nameForCrossEntityAggregateMetrics(String nameForCrossEntityAggregateMetrics) {
        this.nameForCrossEntityAggregateMetrics = nameForCrossEntityAggregateMetrics;
        return this;
    }

    @ApiModelProperty(value="Returns the string to use to pluralize the name of the entity for cross entity aggregate metrics.")
    public String getNameForCrossEntityAggregateMetrics() {
        return this.nameForCrossEntityAggregateMetrics;
    }

    public void setNameForCrossEntityAggregateMetrics(String nameForCrossEntityAggregateMetrics) {
        this.nameForCrossEntityAggregateMetrics = nameForCrossEntityAggregateMetrics;
    }

    public ApiTimeSeriesEntityType displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="Returns the display name of the entity type.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiTimeSeriesEntityType description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Returns the description of the entity type.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApiTimeSeriesEntityType immutableAttributeNames(List<String> immutableAttributeNames) {
        this.immutableAttributeNames = immutableAttributeNames;
        return this;
    }

    public ApiTimeSeriesEntityType addImmutableAttributeNamesItem(String immutableAttributeNamesItem) {
        if (this.immutableAttributeNames == null) {
            this.immutableAttributeNames = new ArrayList<String>();
        }
        this.immutableAttributeNames.add(immutableAttributeNamesItem);
        return this;
    }

    @ApiModelProperty(value="Returns the list of immutable attributes for this entity type. Immutable attributes values for an entity may not change over its lifetime.")
    public List<String> getImmutableAttributeNames() {
        return this.immutableAttributeNames;
    }

    public void setImmutableAttributeNames(List<String> immutableAttributeNames) {
        this.immutableAttributeNames = immutableAttributeNames;
    }

    public ApiTimeSeriesEntityType mutableAttributeNames(List<String> mutableAttributeNames) {
        this.mutableAttributeNames = mutableAttributeNames;
        return this;
    }

    public ApiTimeSeriesEntityType addMutableAttributeNamesItem(String mutableAttributeNamesItem) {
        if (this.mutableAttributeNames == null) {
            this.mutableAttributeNames = new ArrayList<String>();
        }
        this.mutableAttributeNames.add(mutableAttributeNamesItem);
        return this;
    }

    @ApiModelProperty(value="Returns the list of mutable attributes for this entity type. Mutable attributes for an entity may change over its lifetime.")
    public List<String> getMutableAttributeNames() {
        return this.mutableAttributeNames;
    }

    public void setMutableAttributeNames(List<String> mutableAttributeNames) {
        this.mutableAttributeNames = mutableAttributeNames;
    }

    public ApiTimeSeriesEntityType entityNameFormat(List<String> entityNameFormat) {
        this.entityNameFormat = entityNameFormat;
        return this;
    }

    public ApiTimeSeriesEntityType addEntityNameFormatItem(String entityNameFormatItem) {
        if (this.entityNameFormat == null) {
            this.entityNameFormat = new ArrayList<String>();
        }
        this.entityNameFormat.add(entityNameFormatItem);
        return this;
    }

    @ApiModelProperty(value="Returns a list of attribute names that will be used to construct entity names for entities of this type. The attributes named here must be immutable attributes of this type or a parent type.")
    public List<String> getEntityNameFormat() {
        return this.entityNameFormat;
    }

    public void setEntityNameFormat(List<String> entityNameFormat) {
        this.entityNameFormat = entityNameFormat;
    }

    public ApiTimeSeriesEntityType entityDisplayNameFormat(String entityDisplayNameFormat) {
        this.entityDisplayNameFormat = entityDisplayNameFormat;
        return this;
    }

    @ApiModelProperty(value="Returns a format string that will be used to construct the display name of entities of this type. If this returns null the entity name would be used as the display name.  The entity attribute values are used to replace $attribute name portions of this format string. For example, an entity with roleType \"DATANODE\" and hostname \"foo.com\" will have a display name \"DATANODE (foo.com)\" if the format is \"$roleType ($hostname)\".")
    public String getEntityDisplayNameFormat() {
        return this.entityDisplayNameFormat;
    }

    public void setEntityDisplayNameFormat(String entityDisplayNameFormat) {
        this.entityDisplayNameFormat = entityDisplayNameFormat;
    }

    public ApiTimeSeriesEntityType parentMetricEntityTypeNames(List<String> parentMetricEntityTypeNames) {
        this.parentMetricEntityTypeNames = parentMetricEntityTypeNames;
        return this;
    }

    public ApiTimeSeriesEntityType addParentMetricEntityTypeNamesItem(String parentMetricEntityTypeNamesItem) {
        if (this.parentMetricEntityTypeNames == null) {
            this.parentMetricEntityTypeNames = new ArrayList<String>();
        }
        this.parentMetricEntityTypeNames.add(parentMetricEntityTypeNamesItem);
        return this;
    }

    @ApiModelProperty(value="Returns a list of metric entity type names which are parents of this metric entity type. A metric entity type inherits the attributes of its ancestors. For example a role metric entity type has its service as a parent. A service metric entity type has a cluster as a parent. The role type inherits its cluster name attribute through its service parent. Only parent ancestors should be returned here. In the example given, only the service metric entity type should be specified in the parent list.")
    public List<String> getParentMetricEntityTypeNames() {
        return this.parentMetricEntityTypeNames;
    }

    public void setParentMetricEntityTypeNames(List<String> parentMetricEntityTypeNames) {
        this.parentMetricEntityTypeNames = parentMetricEntityTypeNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiTimeSeriesEntityType apiTimeSeriesEntityType = (ApiTimeSeriesEntityType)o;
        return Objects.equals(this.name, apiTimeSeriesEntityType.name) && Objects.equals(this.category, apiTimeSeriesEntityType.category) && Objects.equals(this.nameForCrossEntityAggregateMetrics, apiTimeSeriesEntityType.nameForCrossEntityAggregateMetrics) && Objects.equals(this.displayName, apiTimeSeriesEntityType.displayName) && Objects.equals(this.description, apiTimeSeriesEntityType.description) && Objects.equals(this.immutableAttributeNames, apiTimeSeriesEntityType.immutableAttributeNames) && Objects.equals(this.mutableAttributeNames, apiTimeSeriesEntityType.mutableAttributeNames) && Objects.equals(this.entityNameFormat, apiTimeSeriesEntityType.entityNameFormat) && Objects.equals(this.entityDisplayNameFormat, apiTimeSeriesEntityType.entityDisplayNameFormat) && Objects.equals(this.parentMetricEntityTypeNames, apiTimeSeriesEntityType.parentMetricEntityTypeNames);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.category, this.nameForCrossEntityAggregateMetrics, this.displayName, this.description, this.immutableAttributeNames, this.mutableAttributeNames, this.entityNameFormat, this.entityDisplayNameFormat, this.parentMetricEntityTypeNames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiTimeSeriesEntityType {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    nameForCrossEntityAggregateMetrics: ").append(this.toIndentedString(this.nameForCrossEntityAggregateMetrics)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    immutableAttributeNames: ").append(this.toIndentedString(this.immutableAttributeNames)).append("\n");
        sb.append("    mutableAttributeNames: ").append(this.toIndentedString(this.mutableAttributeNames)).append("\n");
        sb.append("    entityNameFormat: ").append(this.toIndentedString(this.entityNameFormat)).append("\n");
        sb.append("    entityDisplayNameFormat: ").append(this.toIndentedString(this.entityDisplayNameFormat)).append("\n");
        sb.append("    parentMetricEntityTypeNames: ").append(this.toIndentedString(this.parentMetricEntityTypeNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

