/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.SuiteRunner;
import org.testng.TestNGCommandLineArgs;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.internal.AnnotationTypeEnum;
import org.testng.internal.ClassHelper;
import org.testng.internal.HostFile;
import org.testng.internal.IResultListener;
import org.testng.internal.Invoker;
import org.testng.internal.Utils;
import org.testng.internal.annotations.DefaultAnnotationTransformer;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IAnnotationTransformer;
import org.testng.internal.annotations.ITest;
import org.testng.internal.annotations.JDK14AnnotationFinder;
import org.testng.internal.remote.SlavePool;
import org.testng.internal.thread.ThreadUtil;
import org.testng.internal.version.VersionInfo;
import org.testng.log4testng.Logger;
import org.testng.remote.ConnectionInfo;
import org.testng.remote.RemoteSuiteWorker;
import org.testng.remote.RemoteTestWorker;
import org.testng.remote.RemoteWorker;
import org.testng.reporters.EmailableReporter;
import org.testng.reporters.FailedReporter;
import org.testng.reporters.SuiteHTMLReporter;
import org.testng.xml.Parser;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNG {
    private static final Logger LOGGER = Logger.getLogger(class$org$testng$TestNG == null ? (class$org$testng$TestNG = TestNG.class$("org.testng.TestNG")) : class$org$testng$TestNG);
    public static final String DEFAULT_COMMAND_LINE_SUITE_NAME = "Command line suite";
    public static final String DEFAULT_COMMAND_LINE_TEST_NAME = "Command line test";
    public static final String DEFAULT_OUTPUTDIR = "test-output";
    public static final String SRC_SEPARATOR = ";";
    public static final String JDK_ANNOTATION_TYPE = AnnotationTypeEnum.JDK.getName();
    public static final String JAVADOC_ANNOTATION_TYPE = AnnotationTypeEnum.JAVADOC.getName();
    private static TestNG m_instance;
    protected List<XmlSuite> m_suites = new ArrayList<XmlSuite>();
    protected List<XmlSuite> m_cmdlineSuites;
    protected String m_outputDir = "test-output";
    protected String[] m_sourceDirs;
    private AnnotationTypeEnum m_defaultAnnotations = VersionInfo.getDefaultAnnotationType();
    protected IAnnotationFinder m_javadocAnnotationFinder;
    protected IAnnotationFinder m_jdkAnnotationFinder;
    protected String[] m_includedGroups;
    protected String[] m_excludedGroups;
    private Boolean m_isJUnit = Boolean.FALSE;
    protected boolean m_useDefaultListeners = true;
    protected ITestRunnerFactory m_testRunnerFactory;
    protected List<ITestListener> m_testListeners = new ArrayList<ITestListener>();
    protected List<ISuiteListener> m_suiteListeners = new ArrayList<ISuiteListener>();
    private List<IReporter> m_reporters = new ArrayList<IReporter>();
    public static final int HAS_FAILURE = 1;
    public static final int HAS_SKIPPED = 2;
    public static final int HAS_FSP = 4;
    public static final int HAS_NO_TEST = 8;
    protected int m_status;
    protected boolean m_hasTests = false;
    private int m_clientPort = 0;
    private String m_hostFile;
    private SlavePool m_slavePool = new SlavePool();
    private int m_threadCount;
    private boolean m_useThreadCount;
    private String m_parallelMode;
    private boolean m_useParallelMode;
    private Class[] m_commandLineTestClasses;
    private String m_defaultSuiteName = "Command line suite";
    private String m_defaultTestName = "Command line test";
    private Map<String, Integer> m_methodDescriptors = new HashMap<String, Integer>();
    private Integer m_verbose;
    private IAnnotationTransformer m_annotationTransformer = new DefaultAnnotationTransformer();
    static /* synthetic */ Class class$org$testng$TestNG;
    static /* synthetic */ Class class$org$testng$internal$annotations$ITest;

    public TestNG() {
        this.init(true);
    }

    public TestNG(boolean useDefaultListeners) {
        this.init(useDefaultListeners);
    }

    private void init(boolean useDefaultListeners) {
        m_instance = this;
        this.m_useDefaultListeners = useDefaultListeners;
    }

    public int getStatus() {
        return this.m_status;
    }

    protected void setStatus(int status) {
        this.m_status |= status;
    }

    public void setOutputDirectory(String outputdir) {
        if (null != outputdir && !"".equals(outputdir)) {
            this.m_outputDir = outputdir;
        }
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.m_useDefaultListeners = useDefaultListeners;
    }

    @Deprecated
    public void setTarget(String target) {
        LOGGER.warn("The usage of -target option is deprecated. Please use -annotations instead.");
        if (null == target) {
            return;
        }
        this.setAnnotations(target);
    }

    public void setAnnotations(String annotationType) {
        if (null != annotationType && !"".equals(annotationType)) {
            this.setAnnotations(AnnotationTypeEnum.valueOf(annotationType));
        }
    }

    private void setAnnotations(AnnotationTypeEnum annotationType) {
        if (null != annotationType) {
            this.m_defaultAnnotations = annotationType;
        }
    }

    public void setSourcePath(String sourcePaths) {
        LOGGER.debug(new StringBuffer().append("setSourcePath: \"").append(sourcePaths).append("\"").toString());
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("testng-sourcedir-override.properties");
        if (is != null) {
            Properties props = new Properties();
            try {
                props.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading testng-sourcedir-override.properties", e);
            }
            sourcePaths = props.getProperty("sourcedir");
            LOGGER.debug(new StringBuffer().append("setSourcePath ignoring sourcepath parameter and using testng-sourcedir-override.properties: \"").append(sourcePaths).append("\"").toString());
        }
        if (null == sourcePaths || "".equals(sourcePaths.trim())) {
            return;
        }
        this.m_sourceDirs = Utils.split(sourcePaths, SRC_SEPARATOR);
    }

    public void setTestJar(String jarPath) {
        if (null == jarPath || "".equals(jarPath)) {
            return;
        }
        File jarFile = new File(jarPath);
        try {
            URL jarfile = new URL("jar", "", new StringBuffer().append("file:").append(jarFile.getAbsolutePath()).append("!/").toString());
            URLClassLoader jarLoader = new URLClassLoader(new URL[]{jarfile});
            Thread.currentThread().setContextClassLoader(jarLoader);
            this.m_suites.addAll(new Parser().parse());
        }
        catch (MalformedURLException mfurle) {
            System.err.println(new StringBuffer().append("could not find jar file named: ").append(jarFile.getAbsolutePath()).toString());
        }
        catch (IOException ioe) {
            System.out.println(new StringBuffer().append("An exception occurred while trying to load testng.xml from within jar ").append(jarFile.getAbsolutePath()).toString());
        }
        catch (SAXException saxe) {
            System.out.println(new StringBuffer().append("testng.xml from within jar ").append(jarFile.getAbsolutePath()).append(" is not well formatted").toString());
            saxe.printStackTrace(System.out);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace(System.out);
        }
    }

    public void setThreadCount(int threadCount) {
        if (threadCount < 1) {
            TestNG.exitWithError(new StringBuffer().append("Cannot use a threadCount parameter less than 1; 1 > ").append(threadCount).toString());
        }
        this.m_threadCount = threadCount;
        this.m_useThreadCount = true;
    }

    public void setParallel(String parallel) {
        this.m_parallelMode = parallel;
        this.m_useParallelMode = true;
    }

    public void setCommandLineSuite(XmlSuite suite) {
        this.m_cmdlineSuites = new ArrayList<XmlSuite>();
        this.m_cmdlineSuites.add(suite);
        this.m_suites.add(suite);
    }

    public void setTestClasses(Class[] classes) {
        this.m_commandLineTestClasses = classes;
    }

    private IAnnotationFinder getAnnotationFinder() {
        return AnnotationTypeEnum.JDK == this.m_defaultAnnotations ? this.m_jdkAnnotationFinder : this.m_javadocAnnotationFinder;
    }

    private List<XmlSuite> createCommandLineSuites(Class[] classes) {
        XmlClass[] xmlClasses = Utils.classesToXmlClasses(classes);
        HashMap<String, XmlSuite> suites = new HashMap<String, XmlSuite>();
        IAnnotationFinder finder = this.getAnnotationFinder();
        for (int i = 0; i < classes.length; ++i) {
            XmlSuite xmlSuite;
            Class c = classes[i];
            ITest test = (ITest)finder.findAnnotation(c, class$org$testng$internal$annotations$ITest == null ? TestNG.class$("org.testng.internal.annotations.ITest") : class$org$testng$internal$annotations$ITest);
            String suiteName = this.getDefaultSuiteName();
            String testName = this.getDefaultTestName();
            if (test != null) {
                String candidateTestName;
                String candidateSuiteName = test.getSuiteName();
                if (candidateSuiteName != null && !"".equals(candidateSuiteName)) {
                    suiteName = candidateSuiteName;
                }
                if ((candidateTestName = test.getTestName()) != null && !"".equals(candidateTestName)) {
                    testName = candidateTestName;
                }
            }
            if ((xmlSuite = (XmlSuite)suites.get(suiteName)) == null) {
                xmlSuite = new XmlSuite();
                xmlSuite.setName(suiteName);
                suites.put(suiteName, xmlSuite);
            }
            XmlTest xmlTest = null;
            for (XmlTest xt : xmlSuite.getTests()) {
                if (!xt.getName().equals(testName)) continue;
                xmlTest = xt;
                break;
            }
            if (xmlTest == null) {
                xmlTest = new XmlTest(xmlSuite);
                xmlTest.setName(testName);
            }
            List<XmlMethodSelector> selectors = xmlTest.getMethodSelectors();
            for (String name : this.m_methodDescriptors.keySet()) {
                XmlMethodSelector xms = new XmlMethodSelector();
                xms.setName(name);
                xms.setPriority(this.m_methodDescriptors.get(name));
                selectors.add(xms);
            }
            xmlTest.getXmlClasses().add(xmlClasses[i]);
        }
        return new ArrayList<XmlSuite>(suites.values());
    }

    public void addMethodSelector(String className, int priority) {
        this.m_methodDescriptors.put(className, new Integer(priority));
    }

    public void setTestSuites(List<String> suites) {
        for (String suiteXmlPath : suites) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(new StringBuffer().append("suiteXmlPath: \"").append(suiteXmlPath).append("\"").toString());
            }
            try {
                Collection<XmlSuite> allSuites = new Parser(suiteXmlPath).parse();
                for (XmlSuite s : allSuites) {
                    this.m_suites.add(s);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.out);
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace(System.out);
            }
            catch (SAXException e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public void setXmlSuites(List<XmlSuite> suites) {
        this.m_suites = suites;
    }

    public void setExcludedGroups(String groups) {
        this.m_excludedGroups = Utils.split(groups, ",");
    }

    public void setGroups(String groups) {
        this.m_includedGroups = Utils.split(groups, ",");
    }

    protected void setTestRunnerFactoryClass(Class testRunnerFactoryClass) {
        this.setTestRunnerFactory((ITestRunnerFactory)ClassHelper.newInstance(testRunnerFactoryClass));
    }

    protected void setTestRunnerFactory(ITestRunnerFactory itrf) {
        this.m_testRunnerFactory = itrf;
    }

    public void setListenerClasses(List<Class> classes) {
        for (Class cls : classes) {
            this.addListener(ClassHelper.newInstance(cls));
        }
    }

    private void setListeners(List<Object> itls) {
        for (Object obj : itls) {
            this.addListener(obj);
        }
    }

    public void addListener(Object listener) {
        if (!(listener instanceof ISuiteListener || listener instanceof ITestListener || listener instanceof IReporter || listener instanceof IAnnotationTransformer)) {
            TestNG.exitWithError(new StringBuffer().append("Listener ").append(listener).append(" must be one of ITestListener, ISuiteListener, IReporter or IAnnotationTransformer").toString());
        } else {
            if (listener instanceof ISuiteListener) {
                this.addListener((ISuiteListener)listener);
            }
            if (listener instanceof ITestListener) {
                this.addListener((ITestListener)listener);
            }
            if (listener instanceof IReporter) {
                this.addListener((IReporter)listener);
            }
            if (listener instanceof IAnnotationTransformer) {
                this.setAnnotationTransformer((IAnnotationTransformer)listener);
            }
        }
    }

    public void addListener(ISuiteListener listener) {
        if (null != listener) {
            this.m_suiteListeners.add(listener);
        }
    }

    public void addListener(ITestListener listener) {
        if (null != listener) {
            this.m_testListeners.add(listener);
        }
    }

    public void addListener(IReporter listener) {
        if (null != listener) {
            this.m_reporters.add(listener);
        }
    }

    public List<IReporter> getReporters() {
        return this.m_reporters;
    }

    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    public List<ISuiteListener> getSuiteListeners() {
        return this.m_suiteListeners;
    }

    public void setVerbose(int verbose) {
        this.m_verbose = new Integer(verbose);
    }

    private void initializeCommandLineSuites() {
        if (null != this.m_commandLineTestClasses) {
            this.m_cmdlineSuites = this.createCommandLineSuites(this.m_commandLineTestClasses);
            for (XmlSuite s : this.m_cmdlineSuites) {
                this.m_suites.add(s);
            }
        }
    }

    private void initializeCommandLineSuitesParams() {
        if (null == this.m_cmdlineSuites) {
            return;
        }
        for (XmlSuite s : this.m_cmdlineSuites) {
            if (this.m_useThreadCount) {
                s.setThreadCount(this.m_threadCount);
            }
            if (!this.m_useParallelMode) continue;
            s.setParallel(this.m_parallelMode);
        }
    }

    private void initializeCommandLineSuitesGroups() {
        if (null != this.m_cmdlineSuites) {
            for (XmlSuite s : this.m_cmdlineSuites) {
                if (null != this.m_includedGroups && this.m_includedGroups.length > 0) {
                    s.getTests().get(0).setIncludedGroups(Arrays.asList(this.m_includedGroups));
                }
                if (null == this.m_excludedGroups || this.m_excludedGroups.length <= 0) continue;
                s.getTests().get(0).setExcludedGroups(Arrays.asList(this.m_excludedGroups));
            }
        }
    }

    private void initializeListeners() {
        this.m_testListeners.add(new ExitCodeListener(this));
        if (this.m_useDefaultListeners) {
            this.m_reporters.add(new SuiteHTMLReporter());
            this.m_reporters.add(new FailedReporter());
            this.m_reporters.add(new EmailableReporter());
        }
    }

    private void initializeAnnotationFinders() {
        this.m_javadocAnnotationFinder = new JDK14AnnotationFinder(this.getAnnotationTransformer());
        if (null != this.m_sourceDirs) {
            this.m_javadocAnnotationFinder.addSourceDirs(this.m_sourceDirs);
        }
    }

    public void run() {
        this.initializeListeners();
        this.initializeAnnotationFinders();
        this.initializeCommandLineSuites();
        this.initializeCommandLineSuitesParams();
        this.initializeCommandLineSuitesGroups();
        List<ISuite> suiteRunners = null;
        if (this.m_clientPort != 0) {
            this.waitForSuites();
        } else {
            suiteRunners = this.m_hostFile == null ? this.runSuitesLocally() : this.runSuitesRemotely();
        }
        if (null != suiteRunners) {
            this.generateReports(suiteRunners);
        }
        if (!this.m_hasTests) {
            this.setStatus(8);
            if (TestRunner.getVerbose() > 1) {
                System.err.println("[TestNG] No tests found. Nothing was run");
            }
        }
    }

    private void generateReports(List<ISuite> suiteRunners) {
        for (IReporter reporter : this.m_reporters) {
            try {
                reporter.generateReport(this.m_suites, suiteRunners, this.m_outputDir);
            }
            catch (Exception ex) {
                System.err.println(new StringBuffer().append("[TestNG] Reporter ").append(reporter).append(" failed").toString());
                ex.printStackTrace(System.err);
            }
        }
    }

    private static ConnectionInfo resetSocket(int clientPort, ConnectionInfo oldCi) throws IOException {
        ConnectionInfo result = new ConnectionInfo();
        ServerSocket serverSocket = new ServerSocket(clientPort);
        serverSocket.setReuseAddress(true);
        TestNG.log(new StringBuffer().append("Waiting for connections on port ").append(clientPort).toString());
        Socket socket = serverSocket.accept();
        result.setSocket(socket);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void waitForSuites() {
        try {
            ci = TestNG.resetSocket(this.m_clientPort, null);
            while (true) lbl-1000:
            // 4 sources

            {
                try {
                    while (true) {
                        s = (XmlSuite)ci.getOis().readObject();
                        TestNG.log(new StringBuffer().append("Processing ").append(s.getName()).toString());
                        this.m_suites = new ArrayList<XmlSuite>();
                        this.m_suites.add(s);
                        suiteRunners = this.runSuitesLocally();
                        sr = suiteRunners.get(0);
                        TestNG.log(new StringBuffer().append("Done processing ").append(s.getName()).toString());
                        ci.getOos().writeObject(sr);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace(System.out);
                }
                catch (EOFException ex) {
                    TestNG.log(new StringBuffer().append("Connection closed ").append(ex.getMessage()).toString());
                    ci = TestNG.resetSocket(this.m_clientPort, ci);
                }
                catch (SocketException ex) {
                    TestNG.log(new StringBuffer().append("Connection closed ").append(ex.getMessage()).toString());
                    ci = TestNG.resetSocket(this.m_clientPort, ci);
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.out);
            return;
        }
        ** GOTO lbl-1000
    }

    private static void log(String string) {
        Utils.log("", 2, string);
    }

    private List<ISuite> runSuitesRemotely() {
        ArrayList<ISuite> result = new ArrayList<ISuite>();
        HostFile hostFile = new HostFile(this.m_hostFile);
        String[] hosts = hostFile.getHosts();
        Socket[] sockets = new Socket[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            String host = hosts[i];
            String[] stringArray = host.split(":");
            try {
                sockets[i] = new Socket(stringArray[0], Integer.parseInt(stringArray[1]));
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace(System.out);
                continue;
            }
            catch (UnknownHostException e) {
                e.printStackTrace(System.out);
                continue;
            }
            catch (IOException e) {
                Utils.error(new StringBuffer().append("Couldn't connect to ").append(host).append(": ").append(e.getMessage()).toString());
            }
        }
        try {
            this.m_slavePool.addSlaves(sockets);
        }
        catch (IOException e1) {
            e1.printStackTrace(System.out);
        }
        ArrayList<RemoteWorker> workers = new ArrayList<RemoteWorker>();
        if (hostFile.isStrategyTest()) {
            for (XmlSuite xmlSuite : this.m_suites) {
                xmlSuite.setVerbose(new Integer(hostFile.getVerbose()));
                SuiteRunner suiteRunner = new SuiteRunner(xmlSuite, this.m_outputDir, new IAnnotationFinder[]{this.m_javadocAnnotationFinder, this.m_jdkAnnotationFinder});
                for (XmlTest test : xmlSuite.getTests()) {
                    XmlSuite tmpSuite = new XmlSuite();
                    tmpSuite.setXmlPackages(xmlSuite.getXmlPackages());
                    tmpSuite.setAnnotations(xmlSuite.getAnnotations());
                    tmpSuite.setJUnit(xmlSuite.isJUnit());
                    tmpSuite.setName(new StringBuffer().append("Temporary suite for ").append(test.getName()).toString());
                    tmpSuite.setParallel(xmlSuite.getParallel());
                    tmpSuite.setParameters(xmlSuite.getParameters());
                    tmpSuite.setThreadCount(xmlSuite.getThreadCount());
                    tmpSuite.setVerbose(xmlSuite.getVerbose());
                    XmlTest tmpTest = new XmlTest(tmpSuite);
                    tmpTest.setAnnotations(test.getAnnotations());
                    tmpTest.setBeanShellExpression(test.getExpression());
                    tmpTest.setXmlClasses(test.getXmlClasses());
                    tmpTest.setExcludedGroups(test.getExcludedGroups());
                    tmpTest.setIncludedGroups(test.getIncludedGroups());
                    tmpTest.setJUnit(test.isJUnit());
                    tmpTest.setMethodSelectors(test.getMethodSelectors());
                    tmpTest.setName(test.getName());
                    tmpTest.setParallel(test.getParallel());
                    tmpTest.setParameters(test.getParameters());
                    tmpTest.setVerbose(test.getVerbose());
                    tmpTest.setXmlClasses(test.getXmlClasses());
                    tmpTest.setXmlPackages(test.getXmlPackages());
                    workers.add(new RemoteTestWorker(tmpSuite, this.m_slavePool, suiteRunner, result));
                }
                result.add(suiteRunner);
            }
        } else {
            for (XmlSuite xmlSuite : this.m_suites) {
                workers.add(new RemoteSuiteWorker(xmlSuite, this.m_slavePool, result));
            }
        }
        ThreadUtil.execute(workers, 1, 10000L, false);
        for (ISuite iSuite : result) {
            for (ISuiteResult suiteResult : iSuite.getResults().values()) {
                Collection[] allTests;
                for (Collection all : allTests = new Collection[]{suiteResult.getTestContext().getPassedTests().getAllResults(), suiteResult.getTestContext().getFailedTests().getAllResults(), suiteResult.getTestContext().getSkippedTests().getAllResults(), suiteResult.getTestContext().getFailedButWithinSuccessPercentageTests().getAllResults()}) {
                    for (ITestResult tr : all) {
                        Invoker.runTestListeners(tr, this.m_testListeners);
                    }
                }
            }
        }
        return result;
    }

    public List<ISuite> runSuitesLocally() {
        ArrayList<ISuite> result = new ArrayList<ISuite>();
        int v = TestRunner.getVerbose();
        if (TestRunner.getVerbose() > 0) {
            StringBuffer allFiles = new StringBuffer();
            for (XmlSuite s : this.m_suites) {
                allFiles.append("  ").append(s.getFileName() != null ? s.getFileName() : this.getDefaultSuiteName()).append("\n");
            }
            Utils.log("Parser", 0, new StringBuffer().append("Running:\n").append(allFiles.toString()).toString());
        }
        if (this.m_suites.size() > 0) {
            for (XmlSuite xmlSuite : this.m_suites) {
                xmlSuite.setDefaultAnnotations(this.m_defaultAnnotations.toString());
                if (null != this.m_isJUnit) {
                    xmlSuite.setJUnit(this.m_isJUnit);
                }
                if (null != this.m_verbose) {
                    xmlSuite.setVerbose(this.m_verbose);
                }
                result.add(this.createAndRunSuiteRunners(xmlSuite));
            }
        } else {
            this.setStatus(8);
            System.err.println("[ERROR]: No test suite found.  Nothing to run");
        }
        return result;
    }

    protected SuiteRunner createAndRunSuiteRunners(XmlSuite xmlSuite) {
        SuiteRunner result = new SuiteRunner(xmlSuite, this.m_outputDir, this.m_testRunnerFactory, this.m_useDefaultListeners, new IAnnotationFinder[]{this.m_javadocAnnotationFinder, this.m_jdkAnnotationFinder});
        for (ISuiteListener isl : this.m_suiteListeners) {
            result.addListener(isl);
        }
        result.setTestListeners(this.m_testListeners);
        if (this.m_clientPort != 0) {
            try {
                result.setHost(new StringBuffer().append(InetAddress.getLocalHost()).append(":").append(this.m_clientPort).toString());
            }
            catch (UnknownHostException e) {
                e.printStackTrace(System.out);
            }
        }
        result.run();
        return result;
    }

    public static void main(String[] argv) {
        TestNG testng = TestNG.privateMain(argv, null);
        System.exit(testng.getStatus());
    }

    public static TestNG privateMain(String[] argv, ITestListener listener) {
        Map arguments = TestNG.checkConditions(TestNGCommandLineArgs.parseCommandLine(argv));
        TestNG result = new TestNG();
        if (null != listener) {
            result.addListener(listener);
        }
        result.configure(arguments);
        try {
            result.run();
        }
        catch (TestNGException ex) {
            if (TestRunner.getVerbose() > 1) {
                ex.printStackTrace(System.out);
            } else {
                System.err.println(new StringBuffer().append("[ERROR]: ").append(ex.getMessage()).toString());
            }
            result.setStatus(1);
        }
        return result;
    }

    public void configure(Map cmdLineArgs) {
        List listenerClasses;
        String defaultTestName;
        String defaultSuiteName;
        String client;
        String threadCount;
        String useDefaultListeners;
        List testNgXml;
        Integer verbose = (Integer)cmdLineArgs.get("-log");
        if (null != verbose) {
            this.setVerbose(verbose);
        }
        this.setOutputDirectory((String)cmdLineArgs.get("-d"));
        this.setSourcePath((String)cmdLineArgs.get("-sourcedir"));
        this.setAnnotations((AnnotationTypeEnum)cmdLineArgs.get("-annotations"));
        List testClasses = (List)cmdLineArgs.get("-testclass");
        if (null != testClasses) {
            Class[] classes = testClasses.toArray(new Class[testClasses.size()]);
            this.setTestClasses(classes);
        }
        if (null != (testNgXml = (List)cmdLineArgs.get("testng.suite.definitions"))) {
            this.setTestSuites(testNgXml);
        }
        if (null != (useDefaultListeners = (String)cmdLineArgs.get("-usedefaultlisteners"))) {
            this.setUseDefaultListeners("true".equalsIgnoreCase(useDefaultListeners));
        }
        this.setGroups((String)cmdLineArgs.get("-groups"));
        this.setExcludedGroups((String)cmdLineArgs.get("-excludegroups"));
        this.setTestJar((String)cmdLineArgs.get("-testjar"));
        this.setJUnit((Boolean)cmdLineArgs.get("-junit"));
        this.setHostFile((String)cmdLineArgs.get("-hostfile"));
        String parallelMode = (String)cmdLineArgs.get("-parallel");
        if (parallelMode != null) {
            this.setParallel(parallelMode);
        }
        if ((threadCount = (String)cmdLineArgs.get("-threadcount")) != null) {
            this.setThreadCount(Integer.parseInt(threadCount));
        }
        if ((client = (String)cmdLineArgs.get("-slave")) != null) {
            this.setClientPort(Integer.parseInt(client));
        }
        if ((defaultSuiteName = (String)cmdLineArgs.get("-suitename")) != null) {
            this.setDefaultSuiteName(defaultSuiteName);
        }
        if ((defaultTestName = (String)cmdLineArgs.get("-testname")) != null) {
            this.setDefaultTestName(defaultTestName);
        }
        if (null != (listenerClasses = (List)cmdLineArgs.get("-listener"))) {
            this.setListenerClasses(listenerClasses);
        }
    }

    private void setClientPort(int clientPort) {
        this.m_clientPort = clientPort;
    }

    public void setHostFile(String hostFile) {
        this.m_hostFile = hostFile;
    }

    public void setJUnit(Boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    @Deprecated
    public static void setTestNGVersion() {
        LOGGER.info("setTestNGVersion has been deprecated.");
    }

    public static boolean isJdk14() {
        return true;
    }

    protected static Map checkConditions(Map params) {
        String srcPath;
        List testClasses = (List)params.get("-testclass");
        List testNgXml = (List)params.get("testng.suite.definitions");
        Object testJar = params.get("-testjar");
        Object port = params.get("-slave");
        if (testClasses == null && testNgXml == null && port == null && testJar == null) {
            System.err.println("You need to specify at least one testng.xml or one class");
            TestNG.usage();
            System.exit(-1);
        }
        if (null == (srcPath = (String)params.get("-sourcedir")) || "".equals(srcPath)) {
            throw new TestNGException("No sourcedir was specified");
        }
        String groups = (String)params.get("-groups");
        String excludedGroups = (String)params.get("-excludegroups");
        if ((null != groups || null != excludedGroups) && null == testClasses) {
            throw new TestNGException("Groups option should be used with testclass option");
        }
        return params;
    }

    private static void ppp(String s) {
        System.out.println(new StringBuffer().append("[TestNG] ").append(s).toString());
    }

    public boolean hasFailure() {
        return (this.getStatus() & 1) == 1;
    }

    public boolean hasFailureWithinSuccessPercentage() {
        return (this.getStatus() & 4) == 4;
    }

    public boolean hasSkip() {
        return (this.getStatus() & 2) == 2;
    }

    public static void usage() {
        TestNGCommandLineArgs.usage();
    }

    static void exitWithError(String msg) {
        System.err.println(msg);
        TestNG.usage();
        System.exit(1);
    }

    public String getOutputDirectory() {
        return this.m_outputDir;
    }

    public IAnnotationTransformer getAnnotationTransformer() {
        return this.m_annotationTransformer;
    }

    public void setAnnotationTransformer(IAnnotationTransformer t) {
        this.m_annotationTransformer = t;
    }

    public String getDefaultSuiteName() {
        return this.m_defaultSuiteName;
    }

    public void setDefaultSuiteName(String defaultSuiteName) {
        this.m_defaultSuiteName = defaultSuiteName;
    }

    public String getDefaultTestName() {
        return this.m_defaultTestName;
    }

    public void setDefaultTestName(String defaultTestName) {
        this.m_defaultTestName = defaultTestName;
    }

    @Deprecated
    public static TestNG getDefault() {
        return m_instance;
    }

    @Deprecated
    public void setHasFailure(boolean hasFailure) {
        this.m_status |= 1;
    }

    @Deprecated
    public void setHasFailureWithinSuccessPercentage(boolean hasFailureWithinSuccessPercentage) {
        this.m_status |= 4;
    }

    @Deprecated
    public void setHasSkip(boolean hasSkip) {
        this.m_status |= 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    public static class ExitCodeListener
    implements IResultListener {
        protected TestNG m_mainRunner;

        public ExitCodeListener() {
            this.m_mainRunner = m_instance;
        }

        public ExitCodeListener(TestNG runner) {
            this.m_mainRunner = runner;
        }

        public void onTestFailure(ITestResult result) {
            this.setHasRunTests();
            this.m_mainRunner.setStatus(1);
        }

        public void onTestSkipped(ITestResult result) {
            this.setHasRunTests();
            this.m_mainRunner.setStatus(2);
        }

        public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
            this.setHasRunTests();
            this.m_mainRunner.setStatus(4);
        }

        public void onTestSuccess(ITestResult result) {
            this.setHasRunTests();
        }

        public void onStart(ITestContext context) {
            this.setHasRunTests();
        }

        public void onFinish(ITestContext context) {
        }

        public void onTestStart(ITestResult result) {
            this.setHasRunTests();
        }

        private void setHasRunTests() {
            this.m_mainRunner.m_hasTests = true;
        }

        public void onConfigurationFailure(ITestResult itr) {
            this.m_mainRunner.setStatus(1);
        }

        public void onConfigurationSkip(ITestResult itr) {
            this.m_mainRunner.setStatus(2);
        }

        public void onConfigurationSuccess(ITestResult itr) {
        }
    }
}

