/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import org.junit.internal.runners.ClassRoadie;
import org.junit.internal.runners.CompositeRunner;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestClass;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Suite
extends CompositeRunner {
    private static Set<Class<?>> parents = new HashSet();
    private TestClass fTestClass;

    public Suite(Class<?> klass) throws InitializationError {
        this(klass, Suite.getAnnotatedClasses(klass));
    }

    protected Suite(Class<?> klass, Class<?>[] annotatedClasses) throws InitializationError {
        super(klass.getName());
        this.addParent(klass);
        for (Class<?> each : annotatedClasses) {
            Runner childRunner = Request.aClass(each).getRunner();
            if (childRunner == null) continue;
            this.add(childRunner);
        }
        this.removeParent(klass);
        this.fTestClass = new TestClass(klass);
        MethodValidator methodValidator = new MethodValidator(this.fTestClass);
        methodValidator.validateStaticMethods();
        methodValidator.assertValid();
    }

    private Class<?> addParent(Class<?> parent) throws InitializationError {
        if (!parents.add(parent)) {
            throw new InitializationError(String.format("class '%s' (possibly indirectly) contains itself as a SuiteClass", parent.getName()));
        }
        return parent;
    }

    private void removeParent(Class<?> klass) {
        parents.remove(klass);
    }

    private static Class<?>[] getAnnotatedClasses(Class<?> klass) throws InitializationError {
        SuiteClasses annotation = klass.getAnnotation(SuiteClasses.class);
        if (annotation == null) {
            throw new InitializationError(String.format("class '%s' must have a SuiteClasses annotation", klass.getName()));
        }
        return annotation.value();
    }

    protected void validate(MethodValidator methodValidator) {
        methodValidator.validateStaticMethods();
        methodValidator.validateInstanceMethods();
    }

    @Override
    public void run(final RunNotifier notifier) {
        new ClassRoadie(notifier, this.fTestClass, this.getDescription(), new Runnable(){

            public void run() {
                Suite.this.runChildren(notifier);
            }
        }).runProtected();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuiteClasses {
        public Class<?>[] value();
    }
}

