/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.testng.internal.AnnotationTestConverter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDirectoryConverter {
    private File m_sourceDir;
    private File m_outDir;
    private Map<File, File> m_fileNames;

    public AnnotationDirectoryConverter(File sourceDirectory, File destinationDirectory) {
        this.m_sourceDir = sourceDirectory;
        this.m_outDir = destinationDirectory;
    }

    public int convert() {
        this.m_fileNames = this.convert(this.m_sourceDir);
        File[] files = this.m_fileNames.keySet().toArray(new File[this.m_fileNames.size()]);
        AnnotationTestConverter fc = new AnnotationTestConverter(files, this.m_outDir);
        int converted = fc.convert();
        return converted;
    }

    private boolean isTestFile(File f) {
        return f.getName().endsWith(".java");
    }

    private Map<File, File> convert(File f) {
        HashMap<File, File> result = new HashMap<File, File>();
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = f.listFiles()) {
                File f2 = file.getAbsoluteFile();
                Map<File, File> others = this.convert(f2);
                result.putAll(others);
            }
        } else if (this.isTestFile(f)) {
            result.put(f, f);
        }
        return result;
    }
}

