/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.testng.IMethodSelector;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.internal.annotations.IAnnotation;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IAnnotationTransformer;
import org.testng.junit.IJUnitTestRunner;
import org.testng.xml.XmlMethodSelector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassHelper {
    private static final String JUNIT_TESTRUNNER = "org.testng.junit.JUnitTestRunner";
    private static final String JDK5_ANNOTATIONFINDER_CLASS = "org.testng.internal.annotations.JDK15AnnotationFinder";
    static /* synthetic */ Class class$org$testng$internal$annotations$IFactory;
    static /* synthetic */ Class class$org$testng$internal$annotations$IAnnotationTransformer;

    private ClassHelper() {
    }

    public static Object newInstance(Class clazz) {
        try {
            Object instance = clazz.newInstance();
            return instance;
        }
        catch (IllegalAccessException iae) {
            throw new TestNGException(new StringBuffer().append("Class ").append(clazz.getName()).append(" does not have a no-args constructor").toString(), iae);
        }
        catch (InstantiationException ie) {
            throw new TestNGException(new StringBuffer().append("Cannot instantiate class ").append(clazz.getName()).toString(), ie);
        }
        catch (ExceptionInInitializerError eiierr) {
            throw new TestNGException(new StringBuffer().append("An exception occurred in static initialization of class ").append(clazz.getName()).toString(), eiierr);
        }
        catch (SecurityException se) {
            throw new TestNGException(se);
        }
    }

    public static Class forName(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                return classLoader.loadClass(className);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public static Method findFactoryMethod(Class cls, IAnnotationFinder finder) {
        Method result = null;
        for (Method method : cls.getDeclaredMethods()) {
            IAnnotation f = finder.findAnnotation(method, class$org$testng$internal$annotations$IFactory == null ? ClassHelper.class$("org.testng.internal.annotations.IFactory") : class$org$testng$internal$annotations$IFactory);
            if (null == f) continue;
            if (null != result) {
                throw new TestNGException(new StringBuffer().append(cls.getName()).append(":  only one @Factory method allowed").toString());
            }
            result = method;
        }
        return result;
    }

    public static Set<Method> getAvailableMethods(Class clazz) {
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(clazz.getDeclaredMethods()));
        String fqn = clazz.getName();
        for (Class parent = clazz.getSuperclass(); null != parent; parent = parent.getSuperclass()) {
            methods.addAll(ClassHelper.extractMethods(clazz, parent, methods));
        }
        return methods;
    }

    public static IJUnitTestRunner createTestRunner(TestRunner runner) {
        try {
            IJUnitTestRunner tr = (IJUnitTestRunner)ClassHelper.forName(JUNIT_TESTRUNNER).newInstance();
            tr.setTestResultNotifier(runner);
            return tr;
        }
        catch (Exception ex) {
            throw new TestNGException("Cannot create JUnit runner org.testng.junit.JUnitTestRunner", ex);
        }
    }

    public static IAnnotationFinder createJdkAnnotationFinder(IAnnotationTransformer annoTransformer) {
        try {
            Class clazz = ClassHelper.forName(JDK5_ANNOTATIONFINDER_CLASS);
            Constructor ctor = clazz.getConstructor(class$org$testng$internal$annotations$IAnnotationTransformer == null ? (class$org$testng$internal$annotations$IAnnotationTransformer = ClassHelper.class$("org.testng.internal.annotations.IAnnotationTransformer")) : class$org$testng$internal$annotations$IAnnotationTransformer);
            return (IAnnotationFinder)ctor.newInstance(annoTransformer);
        }
        catch (Exception ex) {
            throw new TestNGException("Cannot create/initialize the JDK5 annotation finder org.testng.internal.annotations.JDK15AnnotationFinder", ex);
        }
    }

    private static Set<Method> extractMethods(Class childClass, Class clazz, Set<Method> collected) {
        HashSet<Method> methods = new HashSet<Method>();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Package childPackage = childClass.getPackage();
        Package classPackage = clazz.getPackage();
        boolean isSamePackage = false;
        if (null == childPackage && null == classPackage) {
            isSamePackage = true;
        }
        if (null != childPackage && null != classPackage) {
            isSamePackage = childPackage.getName().equals(classPackage.getName());
        }
        for (Method method : declaredMethods) {
            int methodModifiers = method.getModifiers();
            if (Modifier.isPublic(methodModifiers) || Modifier.isProtected(methodModifiers)) {
                if (ClassHelper.isOverridden(method, collected)) continue;
                methods.add(method);
                continue;
            }
            if (!isSamePackage || Modifier.isPrivate(methodModifiers) || ClassHelper.isOverridden(method, collected)) continue;
            methods.add(method);
        }
        return methods;
    }

    private static boolean isOverridden(Method method, Set<Method> collectedMethods) {
        Class<?> methodClass = method.getDeclaringClass();
        Class<?>[] methodParams = method.getParameterTypes();
        for (Method m : collectedMethods) {
            Class<?>[] paramTypes = m.getParameterTypes();
            if (!method.getName().equals(m.getName()) || !methodClass.isAssignableFrom(m.getDeclaringClass()) || methodParams.length != paramTypes.length) continue;
            boolean sameParameters = true;
            for (int i = 0; i < methodParams.length; ++i) {
                if (methodParams[i].equals(paramTypes[i])) continue;
                sameParameters = false;
                break;
            }
            if (!sameParameters) continue;
            return true;
        }
        return false;
    }

    public static IMethodSelector createSelector(XmlMethodSelector selector) {
        try {
            Class<?> cls = Class.forName(selector.getClassName());
            return (IMethodSelector)cls.newInstance();
        }
        catch (Exception ex) {
            throw new TestNGException(new StringBuffer().append("Couldn't find method selector : ").append(selector.getClassName()).toString(), ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

