/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.transfer;

import java.time.Duration;
import java.time.Instant;
import org.apache.maven.api.MonotonicClock;
import org.apache.maven.cling.transfer.FileSizeFormat;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jMavenTransferListener
extends AbstractTransferListener {
    protected final Logger out;

    public Slf4jMavenTransferListener() {
        this.out = LoggerFactory.getLogger(Slf4jMavenTransferListener.class);
    }

    public Slf4jMavenTransferListener(Logger out) {
        this.out = out;
    }

    public void transferInitiated(TransferEvent event) {
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "to" : "from";
        TransferResource resource = event.getResource();
        StringBuilder message = new StringBuilder();
        message.append(action).append(' ').append(direction).append(' ').append(resource.getRepositoryId());
        message.append(": ");
        message.append(resource.getRepositoryUrl()).append(resource.getResourceName());
        this.out.info(message.toString());
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.out.warn("{} from {} for {}{}", new Object[]{event.getException().getMessage(), resource.getRepositoryId(), resource.getRepositoryUrl(), resource.getResourceName()});
    }

    public void transferSucceeded(TransferEvent event) {
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "to" : "from";
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        FileSizeFormat format = new FileSizeFormat();
        StringBuilder message = new StringBuilder();
        message.append(action).append(' ').append(direction).append(' ').append(resource.getRepositoryId());
        message.append(": ");
        message.append(resource.getRepositoryUrl()).append(resource.getResourceName()).append(" (");
        format.format(message, contentLength);
        Duration duration = Duration.between(Instant.ofEpochMilli(resource.getTransferStartTime()), MonotonicClock.now());
        if ((duration.getSeconds() | (long)duration.getNano()) > 0L) {
            long bytesPerSecond = Math.round((double)contentLength / (double)duration.toSeconds());
            message.append(" at ");
            format.format(message, bytesPerSecond);
            message.append("/s");
        }
        message.append(')');
        this.out.info(message.toString());
    }
}

