/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.util;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class RestoreStateUtils {
    private static Logger log = Logger.getLogger(RestoreStateUtils.class.getName());

    public static void recursivelyHandleComponentReferencesAndSetValid(FacesContext facesContext, UIComponent parent) {
        RestoreStateUtils.recursivelyHandleComponentReferencesAndSetValid(facesContext, parent, false);
    }

    public static void recursivelyHandleComponentReferencesAndSetValid(FacesContext facesContext, UIComponent parent, boolean forceHandle) {
        Method handleBindingsMethod = RestoreStateUtils.getBindingMethod(parent);
        if (handleBindingsMethod != null && !forceHandle) {
            try {
                handleBindingsMethod.invoke((Object)parent, new Object[0]);
            }
            catch (Throwable th) {
                log.log(Level.SEVERE, "Exception while invoking handleBindings on component with client-id:" + parent.getClientId(facesContext), th);
            }
        } else {
            Iterator<UIComponent> it = parent.getFacetsAndChildren();
            while (it.hasNext()) {
                UIComponent component = it.next();
                ValueExpression binding = component.getValueExpression("binding");
                if (binding != null) {
                    binding.setValue(facesContext.getELContext(), (Object)component);
                }
                RestoreStateUtils.recursivelyHandleComponentReferencesAndSetValid(facesContext, component);
            }
        }
    }

    private static Method getBindingMethod(UIComponent parent) {
        Class<?>[] clazzes = parent.getClass().getInterfaces();
        for (int i = 0; i < clazzes.length; ++i) {
            Class<?> clazz = clazzes[i];
            if (clazz.getName().indexOf("BindingAware") == -1) continue;
            try {
                return parent.getClass().getMethod("handleBindings", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }
}

