/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.converter;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.faces.FacesWrapper;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import java.lang.reflect.Type;
import org.apache.myfaces.cdi.converter.FacesConverterAnnotationLiteral;
import org.apache.myfaces.cdi.util.CDIUtils;

public class FacesConverterCDIWrapper
implements PartialStateHolder,
Converter,
FacesWrapper<Converter> {
    private transient Converter delegate;
    private Class<?> forClass;
    private String converterId;
    private boolean _transient;
    private static final Type CONVERTER_TYPE = new TypeLiteral<Converter<?>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private boolean _initialStateMarked = false;

    public FacesConverterCDIWrapper() {
    }

    public FacesConverterCDIWrapper(Class<? extends Converter> converterClass, Class<?> forClass, String converterId) {
        this.forClass = forClass;
        this.converterId = converterId;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        return this.getWrapped().getAsObject(context, component, value);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        return this.getWrapped().getAsString(context, component, value);
    }

    @Override
    public Converter getWrapped() {
        if (this.delegate == null) {
            BeanManager beanManager = CDIUtils.getBeanManager(FacesContext.getCurrentInstance().getExternalContext());
            if (this.converterId != null) {
                FacesConverterAnnotationLiteral qualifier = new FacesConverterAnnotationLiteral(Object.class, this.converterId, true);
                this.delegate = (Converter)CDIUtils.getInstance(beanManager, CONVERTER_TYPE, true, qualifier);
                if (this.delegate == null) {
                    this.delegate = CDIUtils.getInstance(beanManager, Converter.class, true, qualifier);
                }
            } else if (this.forClass != null) {
                FacesConverterAnnotationLiteral qualifier = new FacesConverterAnnotationLiteral(this.forClass, "", true);
                this.delegate = (Converter)CDIUtils.getInstance(beanManager, CONVERTER_TYPE, true, qualifier);
                if (this.delegate == null) {
                    this.delegate = CDIUtils.getInstance(beanManager, Converter.class, true, qualifier);
                }
            }
        }
        return this.delegate;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.forClass, this.converterId};
            return values;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            this.forClass = (Class)values[0];
            this.converterId = (String)values[1];
        }
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }
}

