/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.generators;

import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.LoadProfile;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.TenantGroup;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.BaseLoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.handlers.PherfWorkHandler;
import org.apache.phoenix.pherf.workload.mt.operations.Operation;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;

public class UniformDistributionLoadEventGenerator
extends BaseLoadEventGenerator {
    private final UniformDistributionSampler sampler;

    public UniformDistributionLoadEventGenerator(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, Properties properties) {
        super(phoenixUtil, model, scenario, properties);
        this.sampler = new UniformDistributionSampler(this.operationFactory.getOperations(), model, scenario);
    }

    public UniformDistributionLoadEventGenerator(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, List<PherfWorkHandler> workHandlers, Properties properties) {
        super(phoenixUtil, model, scenario, workHandlers, properties);
        this.sampler = new UniformDistributionSampler(this.operationFactory.getOperations(), model, scenario);
    }

    @Override
    public TenantOperationInfo next() {
        return this.sampler.nextSample();
    }

    private static class UniformDistributionSampler {
        private final LoadProfile loadProfile;
        private final String modelName;
        private final String scenarioName;
        private final String tableName;
        private final Random distribution;
        private final TenantGroup tenantGroup;
        private final List<Operation> operationList;

        public UniformDistributionSampler(List<Operation> operationList, DataModel model, Scenario scenario) {
            this.modelName = model.getName();
            this.scenarioName = scenario.getName();
            this.tableName = scenario.getTableName();
            this.loadProfile = scenario.getLoadProfile();
            this.operationList = operationList;
            Preconditions.checkArgument(this.loadProfile.getTenantDistribution() != null, "Tenant distribution cannot be null");
            Preconditions.checkArgument(!this.loadProfile.getTenantDistribution().isEmpty(), "Tenant group cannot be empty");
            Preconditions.checkArgument(this.loadProfile.getTenantDistribution().size() == 1, "Tenant group cannot be more than 1");
            this.tenantGroup = this.loadProfile.getTenantDistribution().get(0);
            this.distribution = new Random();
        }

        public TenantOperationInfo nextSample() {
            int sampleIndex = this.distribution.nextInt(this.operationList.size());
            Operation op = this.operationList.get(sampleIndex);
            String tenantGroupId = this.tenantGroup.getId();
            String tenantIdPrefix = Strings.padStart(tenantGroupId, this.loadProfile.getGroupIdLength(), 'x');
            String formattedTenantId = String.format(this.loadProfile.getTenantIdFormat(), tenantIdPrefix.substring(0, this.loadProfile.getGroupIdLength()), 1);
            String paddedTenantId = Strings.padStart(formattedTenantId, this.loadProfile.getTenantIdLength(), 'x');
            String tenantId = paddedTenantId.substring(0, this.loadProfile.getTenantIdLength());
            TenantOperationInfo sample = new TenantOperationInfo(this.modelName, this.scenarioName, this.tableName, tenantGroupId, op.getId(), tenantId, op);
            return sample;
        }
    }
}

