/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.kv;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.api.kv.PTable;
import org.apache.bookkeeper.api.kv.PTableBase;
import org.apache.bookkeeper.api.kv.Txn;
import org.apache.bookkeeper.api.kv.impl.op.OpFactoryImpl;
import org.apache.bookkeeper.api.kv.impl.result.KeyValueFactory;
import org.apache.bookkeeper.api.kv.impl.result.ResultFactory;
import org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.bookkeeper.api.kv.op.Op;
import org.apache.bookkeeper.api.kv.op.OpFactory;
import org.apache.bookkeeper.api.kv.options.DeleteOption;
import org.apache.bookkeeper.api.kv.options.IncrementOption;
import org.apache.bookkeeper.api.kv.options.PutOption;
import org.apache.bookkeeper.api.kv.options.RangeOption;
import org.apache.bookkeeper.api.kv.result.DeleteResult;
import org.apache.bookkeeper.api.kv.result.IncrementResult;
import org.apache.bookkeeper.api.kv.result.PutResult;
import org.apache.bookkeeper.api.kv.result.RangeResult;
import org.apache.bookkeeper.api.kv.result.TxnResult;
import org.apache.bookkeeper.clients.impl.internal.api.HashStreamRanges;
import org.apache.bookkeeper.clients.impl.internal.api.StorageServerClientManager;
import org.apache.bookkeeper.clients.impl.kv.PByteBufTableRangeImpl;
import org.apache.bookkeeper.clients.impl.kv.TableRangeFactory;
import org.apache.bookkeeper.clients.impl.routing.RangeRouter;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.router.ByteBufHashRouter;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.stream.proto.RangeProperties;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PByteBufTableImpl
implements PTable<ByteBuf, ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(PByteBufTableImpl.class);
    static final IllegalStateException CAUSE = new IllegalStateException("No range found for a given routing key");
    private final OpFactory<ByteBuf, ByteBuf> opFactory;
    private final ResultFactory<ByteBuf, ByteBuf> resultFactory;
    private final KeyValueFactory<ByteBuf, ByteBuf> kvFactory;
    private final String streamName;
    private final StreamProperties props;
    private final StorageServerClientManager clientManager;
    private final ScheduledExecutorService executor;
    private final TableRangeFactory<ByteBuf, ByteBuf> trFactory;
    private final PTable<ByteBuf, ByteBuf> failRequestTable;
    private final RangeRouter<ByteBuf> rangeRouter;
    private final ConcurrentMap<Long, PTable<ByteBuf, ByteBuf>> tableRanges;

    public PByteBufTableImpl(String streamName, StreamProperties props, StorageServerClientManager clientManager, ScheduledExecutorService executor, Backoff.Policy backoffPolicy) {
        this(streamName, props, clientManager, executor, (streamProps, rangeProps, executorService, opFactory, resultFactory, kvFactory) -> new PByteBufTableRangeImpl(streamProps.getStreamId(), rangeProps, clientManager.getStorageContainerChannel(rangeProps.getStorageContainerId()), executorService, opFactory, resultFactory, kvFactory, backoffPolicy), Optional.empty());
    }

    public PByteBufTableImpl(String streamName, StreamProperties props, StorageServerClientManager clientManager, ScheduledExecutorService executor, TableRangeFactory<ByteBuf, ByteBuf> factory, Optional<RangeRouter<ByteBuf>> rangeRouterOverride) {
        this.streamName = streamName;
        this.props = props;
        this.clientManager = clientManager;
        this.executor = executor;
        this.trFactory = factory;
        this.rangeRouter = rangeRouterOverride.orElse(new RangeRouter<ByteBuf>(ByteBufHashRouter.of()));
        this.tableRanges = new ConcurrentHashMap<Long, PTable<ByteBuf, ByteBuf>>();
        this.opFactory = new OpFactoryImpl<ByteBuf, ByteBuf>();
        this.resultFactory = new ResultFactory();
        this.kvFactory = new KeyValueFactory();
        this.failRequestTable = new FailRequestKeyValueSpace(this.opFactory);
    }

    @Override
    public OpFactory<ByteBuf, ByteBuf> opFactory() {
        return this.opFactory;
    }

    @VisibleForTesting
    ConcurrentMap<Long, PTable<ByteBuf, ByteBuf>> getTableRanges() {
        return this.tableRanges;
    }

    private PTable<ByteBuf, ByteBuf> getTableRange(Long range) {
        PTable tRange = (PTable)this.tableRanges.get(range);
        if (null == tRange) {
            return this.failRequestTable;
        }
        return tRange;
    }

    public CompletableFuture<PTable<ByteBuf, ByteBuf>> initialize() {
        return this.clientManager.openMetaRangeClient(this.props).getActiveDataRanges().thenComposeAsync(ranges -> this.refreshRangeSpaces((HashStreamRanges)ranges), (Executor)this.executor);
    }

    CompletableFuture<PTable<ByteBuf, ByteBuf>> refreshRangeSpaces(HashStreamRanges newRanges) {
        HashStreamRanges oldRanges = this.rangeRouter.getRanges();
        if (null != oldRanges && oldRanges.getMaxRangeId() >= newRanges.getMaxRangeId()) {
            log.info("No new stream ranges found for stream {}.", (Object)this.streamName);
            return FutureUtils.value((Object)this);
        }
        if (log.isInfoEnabled()) {
            log.info("Updated the active ranges to {}", (Object)newRanges);
        }
        this.rangeRouter.setRanges(newRanges);
        HashSet activeRanges = Sets.newHashSetWithExpectedSize((int)newRanges.getRanges().size());
        newRanges.getRanges().forEach((rk, range) -> {
            activeRanges.add(range.getRangeId());
            if (this.tableRanges.containsKey(range.getRangeId())) {
                return;
            }
            PTable<ByteBuf, ByteBuf> tableRange = this.trFactory.openTableRange(this.props, (RangeProperties)range, this.executor, this.opFactory, this.resultFactory, this.kvFactory);
            if (log.isInfoEnabled()) {
                log.info("Create table range client for range {}", (Object)range.getRangeId());
            }
            this.tableRanges.put(range.getRangeId(), tableRange);
        });
        Iterator rsIter = this.tableRanges.entrySet().iterator();
        while (rsIter.hasNext()) {
            Map.Entry entry = rsIter.next();
            Long rid = (Long)entry.getKey();
            if (activeRanges.contains(rid)) continue;
            rsIter.remove();
            PTable oldRangeSpace = (PTable)entry.getValue();
            oldRangeSpace.close();
        }
        return FutureUtils.value((Object)this);
    }

    @Override
    public CompletableFuture<RangeResult<ByteBuf, ByteBuf>> get(ByteBuf pKey, ByteBuf lKey, RangeOption<ByteBuf> option) {
        Long range = this.rangeRouter.getRange(pKey);
        return this.getTableRange(range).get(pKey, lKey, option);
    }

    @Override
    public CompletableFuture<PutResult<ByteBuf, ByteBuf>> put(ByteBuf pKey, ByteBuf lKey, ByteBuf value, PutOption<ByteBuf> option) {
        Long range = this.rangeRouter.getRange(pKey);
        return this.getTableRange(range).put(pKey, lKey, value, option);
    }

    @Override
    public CompletableFuture<DeleteResult<ByteBuf, ByteBuf>> delete(ByteBuf pKey, ByteBuf lKey, DeleteOption<ByteBuf> option) {
        Long range = this.rangeRouter.getRange(pKey);
        return this.getTableRange(range).delete(pKey, lKey, (ByteBuf)option);
    }

    @Override
    public CompletableFuture<IncrementResult<ByteBuf, ByteBuf>> increment(ByteBuf pKey, ByteBuf lKey, long amount, IncrementOption<ByteBuf> option) {
        Long range = this.rangeRouter.getRange(pKey);
        return this.getTableRange(range).increment(pKey, lKey, amount, option);
    }

    @Override
    public Txn<ByteBuf, ByteBuf> txn(ByteBuf pKey) {
        Long range = this.rangeRouter.getRange(pKey);
        return this.getTableRange(range).txn(pKey);
    }

    @Override
    public void close() {
        this.tableRanges.values().forEach(PTableBase::close);
    }

    static class FailRequestKeyValueSpace
    implements PTable<ByteBuf, ByteBuf> {
        private final OpFactory<ByteBuf, ByteBuf> opFactory;
        private final FailRequestTxn txn;

        private FailRequestKeyValueSpace(OpFactory<ByteBuf, ByteBuf> opFactory) {
            this.opFactory = opFactory;
            this.txn = new FailRequestTxn();
        }

        @Override
        public CompletableFuture<RangeResult<ByteBuf, ByteBuf>> get(ByteBuf pKey, ByteBuf lKey, RangeOption<ByteBuf> option) {
            return FutureUtils.exception((Throwable)CAUSE);
        }

        @Override
        public CompletableFuture<PutResult<ByteBuf, ByteBuf>> put(ByteBuf pKey, ByteBuf lKey, ByteBuf value, PutOption option) {
            return FutureUtils.exception((Throwable)CAUSE);
        }

        @Override
        public CompletableFuture<DeleteResult<ByteBuf, ByteBuf>> delete(ByteBuf pKey, ByteBuf lKey, DeleteOption<ByteBuf> option) {
            return FutureUtils.exception((Throwable)CAUSE);
        }

        @Override
        public CompletableFuture<IncrementResult<ByteBuf, ByteBuf>> increment(ByteBuf pKey, ByteBuf lKey, long amount, IncrementOption<ByteBuf> option) {
            return FutureUtils.exception((Throwable)CAUSE);
        }

        @Override
        public Txn<ByteBuf, ByteBuf> txn(ByteBuf pKey) {
            return this.txn;
        }

        @Override
        public void close() {
        }

        @Override
        public OpFactory<ByteBuf, ByteBuf> opFactory() {
            return this.opFactory;
        }
    }

    private static class FailRequestTxn
    implements Txn<ByteBuf, ByteBuf> {
        private FailRequestTxn() {
        }

        @Override
        public Txn<ByteBuf, ByteBuf> If(CompareOp ... cmps) {
            return this;
        }

        @Override
        public Txn<ByteBuf, ByteBuf> Then(Op ... ops) {
            return this;
        }

        @Override
        public Txn<ByteBuf, ByteBuf> Else(Op ... ops) {
            return this;
        }

        @Override
        public CompletableFuture<TxnResult<ByteBuf, ByteBuf>> commit() {
            return FutureUtils.exception((Throwable)CAUSE);
        }
    }
}

