/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QBMetaData {
    public static final int DEST_INVALID = 0;
    public static final int DEST_TABLE = 1;
    public static final int DEST_PARTITION = 2;
    public static final int DEST_DFS_FILE = 3;
    public static final int DEST_REDUCE = 4;
    public static final int DEST_LOCAL_FILE = 5;
    private final HashMap<String, Table> aliasToTable = new LinkedHashMap<String, Table>();
    private final HashMap<String, Table> nameToDestTable = new HashMap();
    private final HashMap<String, Partition> nameToDestPartition = new HashMap();
    private final HashMap<String, String> nameToDestFile = new HashMap();
    private final HashMap<String, Integer> nameToDestType = new HashMap();
    private final HashMap<String, Map<String, String>> aliasToPartSpec = new LinkedHashMap<String, Map<String, String>>();
    private final HashMap<String, DynamicPartitionCtx> aliasToDPCtx = new LinkedHashMap<String, DynamicPartitionCtx>();
    private static final Logger LOG = LoggerFactory.getLogger((String)QBMetaData.class.getName());

    public HashMap<String, Table> getAliasToTable() {
        return this.aliasToTable;
    }

    public Table getTableForAlias(String alias) {
        return this.aliasToTable.get(alias.toLowerCase());
    }

    public void setSrcForAlias(String alias, Table tab) {
        this.aliasToTable.put(alias, tab);
    }

    public void setDestForAlias(String alias, Table tab) {
        this.nameToDestType.put(alias, 1);
        this.nameToDestTable.put(alias, tab);
    }

    public void setDestForAlias(String alias, Partition part) {
        this.nameToDestType.put(alias, 2);
        this.nameToDestPartition.put(alias, part);
    }

    public void setDestForAlias(String alias, String fname, boolean isDfsFile) {
        this.nameToDestType.put(alias, isDfsFile ? Integer.valueOf(3) : Integer.valueOf(5));
        this.nameToDestFile.put(alias, fname);
    }

    public Integer getDestTypeForAlias(String alias) {
        return this.nameToDestType.get(alias.toLowerCase());
    }

    public Table getDestTableForAlias(String alias) {
        return this.nameToDestTable.get(alias.toLowerCase());
    }

    public Map<String, Table> getNameToDestTable() {
        return this.nameToDestTable;
    }

    public Partition getDestPartitionForAlias(String alias) {
        return this.nameToDestPartition.get(alias.toLowerCase());
    }

    public Map<String, Partition> getNameToDestPartition() {
        return this.nameToDestPartition;
    }

    public String getDestFileForAlias(String alias) {
        return this.nameToDestFile.get(alias.toLowerCase());
    }

    public Table getSrcForAlias(String alias) {
        return this.aliasToTable.get(alias.toLowerCase());
    }

    public Map<String, String> getPartSpecForAlias(String alias) {
        return this.aliasToPartSpec.get(alias);
    }

    public void setPartSpecForAlias(String alias, Map<String, String> partSpec) {
        this.aliasToPartSpec.put(alias, partSpec);
    }

    public void setDPCtx(String alias, DynamicPartitionCtx dpCtx) {
        this.aliasToDPCtx.put(alias, dpCtx);
    }

    public DynamicPartitionCtx getDPCtx(String alias) {
        return this.aliasToDPCtx.get(alias);
    }
}

