/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.io;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.JsonWriter;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.PartitionSerializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;

public class TableSerializer
implements JsonWriter.Serializer {
    public static final String FIELD_NAME = "table";
    private final Table tableHandle;
    private final Iterable<Partition> partitions;
    private final HiveConf hiveConf;

    public TableSerializer(Table tableHandle, Iterable<Partition> partitions, HiveConf hiveConf) {
        this.tableHandle = tableHandle;
        this.partitions = partitions;
        this.hiveConf = hiveConf;
    }

    @Override
    public void writeTo(JsonWriter writer, ReplicationSpec additionalPropertiesProvider) throws SemanticException, IOException {
        if (!Utils.shouldReplicate(additionalPropertiesProvider, this.tableHandle, this.hiveConf).booleanValue()) {
            return;
        }
        org.apache.hadoop.hive.metastore.api.Table tTable = this.tableHandle.getTTable();
        tTable = this.updatePropertiesInTable(tTable, additionalPropertiesProvider);
        try {
            TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
            writer.jsonGenerator.writeStringField(FIELD_NAME, serializer.toString(tTable, "UTF-8"));
            writer.jsonGenerator.writeFieldName("partitions");
            this.writePartitions(writer, additionalPropertiesProvider);
        }
        catch (TException e) {
            throw new SemanticException(ErrorMsg.ERROR_SERIALIZE_METASTORE.getMsg(), e);
        }
    }

    private org.apache.hadoop.hive.metastore.api.Table updatePropertiesInTable(org.apache.hadoop.hive.metastore.api.Table table, ReplicationSpec additionalPropertiesProvider) {
        Map<String, String> parameters = table.getParameters();
        if (parameters != null) {
            parameters.entrySet().removeIf(e -> ((String)e.getKey()).equals("hive.repl.ckpt.key"));
        }
        if (additionalPropertiesProvider.isInReplicationScope()) {
            if (additionalPropertiesProvider.getReplSpecType() != ReplicationSpec.Type.INCREMENTAL_DUMP) {
                table.putToParameters(ReplicationSpec.KEY.CURR_STATE_ID.toString(), additionalPropertiesProvider.getCurrentReplicationState());
            }
            if (this.isExternalTable(table)) {
                table.putToParameters("EXTERNAL", "FALSE");
            }
            if (this.isExternalTableType(table)) {
                table.setTableType(TableType.MANAGED_TABLE.toString());
            }
        }
        return table;
    }

    private boolean isExternalTableType(org.apache.hadoop.hive.metastore.api.Table table) {
        return table.isSetTableType() && table.getTableType().equalsIgnoreCase(TableType.EXTERNAL_TABLE.toString());
    }

    private boolean isExternalTable(org.apache.hadoop.hive.metastore.api.Table table) {
        Map<String, String> params = table.getParameters();
        return params.containsKey("EXTERNAL") && params.get("EXTERNAL").equalsIgnoreCase("TRUE");
    }

    private void writePartitions(JsonWriter writer, ReplicationSpec additionalPropertiesProvider) throws SemanticException, IOException {
        writer.jsonGenerator.writeStartArray();
        if (this.partitions != null) {
            for (Partition partition : this.partitions) {
                new PartitionSerializer(partition.getTPartition()).writeTo(writer, additionalPropertiesProvider);
            }
        }
        writer.jsonGenerator.writeEndArray();
    }
}

