/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.log;

import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.ReplState;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.state.BootstrapDumpBegin;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.state.BootstrapDumpEnd;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.state.BootstrapDumpFunction;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.state.BootstrapDumpTable;

public class BootstrapDumpLogger
extends ReplLogger {
    private String dbName;
    private String dumpDir;
    private long estimatedNumTables;
    private long estimatedNumFunctions;
    private long tableSeqNo;
    private long functionSeqNo;

    public BootstrapDumpLogger(String dbName, String dumpDir, int estimatedNumTables, int estimatedNumFunctions) {
        this.dbName = dbName;
        this.dumpDir = dumpDir;
        this.estimatedNumTables = estimatedNumTables;
        this.estimatedNumFunctions = estimatedNumFunctions;
        this.tableSeqNo = 0L;
        this.functionSeqNo = 0L;
    }

    @Override
    public void startLog() {
        new BootstrapDumpBegin(this.dbName, this.estimatedNumTables, this.estimatedNumFunctions).log(ReplState.LogTag.START);
    }

    @Override
    public void tableLog(String tableName, TableType tableType) {
        ++this.tableSeqNo;
        new BootstrapDumpTable(this.dbName, tableName, tableType, this.tableSeqNo, this.estimatedNumTables).log(ReplState.LogTag.TABLE_DUMP);
    }

    @Override
    public void functionLog(String funcName) {
        ++this.functionSeqNo;
        new BootstrapDumpFunction(this.dbName, funcName, this.functionSeqNo, this.estimatedNumFunctions).log(ReplState.LogTag.FUNCTION_DUMP);
    }

    @Override
    public void endLog(String lastReplId) {
        new BootstrapDumpEnd(this.dbName, this.tableSeqNo, this.functionSeqNo, this.dumpDir, lastReplId).log(ReplState.LogTag.END);
    }
}

