/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.nio.file.Paths;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.util.Time;

public final class OzoneFSUtils {
    private OzoneFSUtils() {
    }

    public static String pathToKey(Path path) {
        return path.toString().substring(1);
    }

    public static String getParent(String keyName) {
        java.nio.file.Path parentDir = Paths.get(keyName, new String[0]).getParent();
        if (parentDir == null) {
            return "";
        }
        return OzoneFSUtils.addTrailingSlashIfNeeded(parentDir.toString());
    }

    public static String getImmediateChild(String descendant, String ancestor) {
        int ancestorPathNameCount;
        String string = ancestor = !ancestor.isEmpty() ? OzoneFSUtils.addTrailingSlashIfNeeded(ancestor) : ancestor;
        if (!descendant.startsWith(ancestor)) {
            return null;
        }
        java.nio.file.Path descendantPath = Paths.get(descendant, new String[0]);
        java.nio.file.Path ancestorPath = Paths.get(ancestor, new String[0]);
        int n = ancestorPathNameCount = ancestor.isEmpty() ? 0 : ancestorPath.getNameCount();
        if (descendantPath.getNameCount() - ancestorPathNameCount > 1) {
            return OzoneFSUtils.addTrailingSlashIfNeeded(ancestor + descendantPath.getName(ancestorPathNameCount));
        }
        return descendant;
    }

    public static String addTrailingSlashIfNeeded(String key) {
        if (!key.endsWith("/")) {
            return key + "/";
        }
        return key;
    }

    public static boolean isFile(String keyName) {
        return !keyName.endsWith("/");
    }

    public static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        String[] components = org.apache.hadoop.util.StringUtils.split((String)src, (char)'/');
        for (int i = 0; i < components.length; ++i) {
            String element = components[i];
            if (element.equals(".") || element.contains(":") || element.contains("/") || element.equals("..")) {
                return false;
            }
            if (!element.isEmpty() || i == components.length - 1 || i == 0) continue;
            return false;
        }
        return true;
    }

    public static void validateBucketLayout(String bucketName, BucketLayout bucketLayout) {
        if (bucketLayout.equals((Object)BucketLayout.OBJECT_STORE)) {
            throw new IllegalArgumentException("Bucket: " + bucketName + " has layout: " + (Object)((Object)bucketLayout) + ", which does not support file system semantics. Bucket Layout must be " + (Object)((Object)BucketLayout.FILE_SYSTEM_OPTIMIZED) + " or " + (Object)((Object)BucketLayout.LEGACY) + ".");
        }
    }

    public static String getFileName(@Nonnull String keyName) {
        java.nio.file.Path fileName = Paths.get(keyName, new String[0]).getFileName();
        if (fileName != null) {
            return fileName.toString();
        }
        return keyName;
    }

    public static boolean isSibling(String parentKey, String childKey) {
        if (StringUtils.isBlank((CharSequence)childKey)) {
            return false;
        }
        java.nio.file.Path parentPath = Paths.get(parentKey, new String[0]);
        java.nio.file.Path childPath = Paths.get(childKey, new String[0]);
        java.nio.file.Path childParent = childPath.getParent();
        java.nio.file.Path parentParent = parentPath.getParent();
        if (childParent != null && parentParent != null) {
            return childParent.equals(parentParent);
        }
        return childParent == parentParent;
    }

    public static boolean isAncestorPath(String parentKey, String childKey) {
        if (StringUtils.isBlank((CharSequence)childKey)) {
            return false;
        }
        java.nio.file.Path parentPath = Paths.get(parentKey, new String[0]);
        java.nio.file.Path childPath = Paths.get(childKey, new String[0]);
        java.nio.file.Path childParent = childPath.getParent();
        java.nio.file.Path parentParent = parentPath.getParent();
        if (childParent != null && parentParent != null) {
            return childParent.startsWith(parentParent) || childParent.equals(parentParent);
        }
        return childParent == parentParent;
    }

    public static boolean isImmediateChild(String parentKey, String childKey) {
        if (StringUtils.isBlank((CharSequence)childKey)) {
            return false;
        }
        java.nio.file.Path parentPath = Paths.get(parentKey, new String[0]);
        java.nio.file.Path childPath = Paths.get(childKey, new String[0]);
        java.nio.file.Path childParent = childPath.getParent();
        if (StringUtils.isBlank((CharSequence)parentKey)) {
            return childParent == null || "/".equals(childParent.toString());
        }
        return parentPath.equals(childParent);
    }

    public static String getParentDir(@Nonnull String keyName) {
        java.nio.file.Path fileName = Paths.get(keyName, new String[0]).getParent();
        if (fileName != null) {
            return fileName.toString();
        }
        return "";
    }

    public static String appendFileNameToKeyPath(String keyName, String fileName) {
        StringBuilder newToKeyName = new StringBuilder(keyName);
        newToKeyName.append("/");
        newToKeyName.append(fileName);
        return newToKeyName.toString();
    }

    public static int getFileCount(String keyName) {
        java.nio.file.Path keyPath = Paths.get(keyName, new String[0]);
        return keyPath.getNameCount();
    }

    public static String removeTrailingSlashIfNeeded(String key) {
        if (key.endsWith("/")) {
            java.nio.file.Path keyPath = Paths.get(key, new String[0]);
            return keyPath.toString();
        }
        return key;
    }

    public static String generateUniqueTempSnapshotName() {
        return "temp" + UUID.randomUUID() + SnapshotInfo.generateName(Time.now());
    }

    public static Path trimPathToDepth(Path path, int maxDepth) {
        Path res = path;
        while (res.depth() > maxDepth) {
            res = res.getParent();
        }
        return res;
    }
}

