/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.protobuf.MessageLite;
import java.util.Objects;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class S3SecretValue {
    private static final Codec<S3SecretValue> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.S3Secret.getDefaultInstance()), S3SecretValue::fromProtobuf, S3SecretValue::getProtobuf);
    private String kerberosID;
    private String awsSecret;
    private boolean isDeleted;
    private long transactionLogIndex;

    public static Codec<S3SecretValue> getCodec() {
        return CODEC;
    }

    public S3SecretValue(String kerberosID, String awsSecret) {
        this(kerberosID, awsSecret, false, 0L);
    }

    public S3SecretValue(String kerberosID, String awsSecret, boolean isDeleted, long transactionLogIndex) {
        this.kerberosID = kerberosID;
        this.awsSecret = awsSecret;
        this.isDeleted = isDeleted;
        this.transactionLogIndex = transactionLogIndex;
    }

    public String getKerberosID() {
        return this.kerberosID;
    }

    public void setKerberosID(String kerberosID) {
        this.kerberosID = kerberosID;
    }

    public String getAwsSecret() {
        return this.awsSecret;
    }

    public void setAwsSecret(String awsSecret) {
        this.awsSecret = awsSecret;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean status) {
        this.isDeleted = status;
    }

    public String getAwsAccessKey() {
        return this.kerberosID;
    }

    public long getTransactionLogIndex() {
        return this.transactionLogIndex;
    }

    public void setTransactionLogIndex(long transactionLogIndex) {
        this.transactionLogIndex = transactionLogIndex;
    }

    public static S3SecretValue fromProtobuf(OzoneManagerProtocolProtos.S3Secret s3Secret) {
        return new S3SecretValue(s3Secret.getKerberosID(), s3Secret.getAwsSecret());
    }

    public OzoneManagerProtocolProtos.S3Secret getProtobuf() {
        return OzoneManagerProtocolProtos.S3Secret.newBuilder().setAwsSecret(this.awsSecret).setKerberosID(this.kerberosID).build();
    }

    public String toString() {
        return "awsAccessKey=" + this.kerberosID + "\nawsSecret=" + this.awsSecret + "\nisDeleted=" + this.isDeleted + "\ntransactionLogIndex=" + this.transactionLogIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3SecretValue that = (S3SecretValue)o;
        return this.kerberosID.equals(that.kerberosID) && this.awsSecret.equals(that.awsSecret) && this.isDeleted == that.isDeleted && this.transactionLogIndex == that.transactionLogIndex;
    }

    public int hashCode() {
        return Objects.hash(this.kerberosID, this.awsSecret, this.isDeleted, this.transactionLogIndex);
    }
}

