/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class SnapshotInfo
implements Auditable,
CopyObject<SnapshotInfo> {
    private static final Codec<SnapshotInfo> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.SnapshotInfo.getDefaultInstance()), SnapshotInfo::getFromProtobuf, SnapshotInfo::getProtobuf);
    private static final String SEPARATOR = "-";
    private static final long INVALID_TIMESTAMP = -1L;
    private static final UUID INITIAL_SNAPSHOT_ID = UUID.randomUUID();
    private final UUID snapshotId;
    private String name;
    private String volumeName;
    private String bucketName;
    private SnapshotStatus snapshotStatus;
    private final long creationTime;
    private long deletionTime;
    private UUID pathPreviousSnapshotId;
    private UUID globalPreviousSnapshotId;
    private String snapshotPath;
    private String checkpointDir;
    private long dbTxSequenceNumber;
    private boolean deepClean;
    private boolean sstFiltered;
    private long referencedSize;
    private long referencedReplicatedSize;
    private long exclusiveSize;
    private long exclusiveReplicatedSize;

    public static Codec<SnapshotInfo> getCodec() {
        return CODEC;
    }

    private SnapshotInfo(UUID snapshotId, String name, String volumeName, String bucketName, SnapshotStatus snapshotStatus, long creationTime, long deletionTime, UUID pathPreviousSnapshotId, UUID globalPreviousSnapshotId, String snapshotPath, String checkpointDir, long dbTxSequenceNumber, boolean deepCleaned, boolean sstFiltered, long referencedSize, long referencedReplicatedSize, long exclusiveSize, long exclusiveReplicatedSize) {
        this.snapshotId = snapshotId;
        this.name = name;
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.snapshotStatus = snapshotStatus;
        this.creationTime = creationTime;
        this.deletionTime = deletionTime;
        this.pathPreviousSnapshotId = pathPreviousSnapshotId;
        this.globalPreviousSnapshotId = globalPreviousSnapshotId;
        this.snapshotPath = snapshotPath;
        this.checkpointDir = checkpointDir;
        this.dbTxSequenceNumber = dbTxSequenceNumber;
        this.deepClean = deepCleaned;
        this.sstFiltered = sstFiltered;
        this.referencedSize = referencedSize;
        this.referencedReplicatedSize = referencedReplicatedSize;
        this.exclusiveSize = exclusiveSize;
        this.exclusiveReplicatedSize = exclusiveReplicatedSize;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setSnapshotStatus(SnapshotStatus snapshotStatus) {
        this.snapshotStatus = snapshotStatus;
    }

    public void setDeletionTime(long delTime) {
        this.deletionTime = delTime;
    }

    public void setPathPreviousSnapshotId(UUID pathPreviousSnapshotId) {
        this.pathPreviousSnapshotId = pathPreviousSnapshotId;
    }

    public void setGlobalPreviousSnapshotId(UUID globalPreviousSnapshotId) {
        this.globalPreviousSnapshotId = globalPreviousSnapshotId;
    }

    public void setSnapshotPath(String snapshotPath) {
        this.snapshotPath = snapshotPath;
    }

    public void setCheckpointDir(String checkpointDir) {
        this.checkpointDir = checkpointDir;
    }

    public boolean getDeepClean() {
        return this.deepClean;
    }

    public void setDeepClean(boolean deepClean) {
        this.deepClean = deepClean;
    }

    public UUID getSnapshotId() {
        return this.snapshotId;
    }

    public String getName() {
        return this.name;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public SnapshotStatus getSnapshotStatus() {
        return this.snapshotStatus;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getDeletionTime() {
        return this.deletionTime;
    }

    public UUID getPathPreviousSnapshotId() {
        return this.pathPreviousSnapshotId;
    }

    public UUID getGlobalPreviousSnapshotId() {
        return this.globalPreviousSnapshotId;
    }

    public String getSnapshotPath() {
        return this.snapshotPath;
    }

    public String getCheckpointDir() {
        return this.checkpointDir;
    }

    public boolean isSstFiltered() {
        return this.sstFiltered;
    }

    public void setSstFiltered(boolean sstFiltered) {
        this.sstFiltered = sstFiltered;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().setSnapshotId(this.snapshotId).setName(this.name).setVolumeName(this.volumeName).setBucketName(this.bucketName).setSnapshotStatus(this.snapshotStatus).setCreationTime(this.creationTime).setDeletionTime(this.deletionTime).setPathPreviousSnapshotId(this.pathPreviousSnapshotId).setGlobalPreviousSnapshotId(this.globalPreviousSnapshotId).setSnapshotPath(this.snapshotPath).setCheckpointDir(this.checkpointDir).setDeepClean(this.deepClean).setSstFiltered(this.sstFiltered).setReferencedSize(this.referencedSize).setReferencedReplicatedSize(this.referencedReplicatedSize).setExclusiveSize(this.exclusiveSize).setExclusiveReplicatedSize(this.exclusiveReplicatedSize);
    }

    public OzoneManagerProtocolProtos.SnapshotInfo getProtobuf() {
        OzoneManagerProtocolProtos.SnapshotInfo.Builder sib = OzoneManagerProtocolProtos.SnapshotInfo.newBuilder().setSnapshotID(HddsUtils.toProtobuf((UUID)this.snapshotId)).setName(this.name).setVolumeName(this.volumeName).setBucketName(this.bucketName).setSnapshotStatus(this.snapshotStatus.toProto()).setCreationTime(this.creationTime).setDeletionTime(this.deletionTime).setSstFiltered(this.sstFiltered).setReferencedSize(this.referencedSize).setReferencedReplicatedSize(this.referencedReplicatedSize).setExclusiveSize(this.exclusiveSize).setExclusiveReplicatedSize(this.exclusiveReplicatedSize);
        if (this.pathPreviousSnapshotId != null) {
            sib.setPathPreviousSnapshotID(HddsUtils.toProtobuf((UUID)this.pathPreviousSnapshotId));
        }
        if (this.globalPreviousSnapshotId != null) {
            sib.setGlobalPreviousSnapshotID(HddsUtils.toProtobuf((UUID)this.globalPreviousSnapshotId));
        }
        sib.setSnapshotPath(this.snapshotPath).setCheckpointDir(this.checkpointDir).setDbTxSequenceNumber(this.dbTxSequenceNumber).setDeepClean(this.deepClean);
        return sib.build();
    }

    public static SnapshotInfo getFromProtobuf(OzoneManagerProtocolProtos.SnapshotInfo snapshotInfoProto) {
        Builder osib = SnapshotInfo.newBuilder().setSnapshotId(HddsUtils.fromProtobuf((HddsProtos.UUID)snapshotInfoProto.getSnapshotID())).setName(snapshotInfoProto.getName()).setVolumeName(snapshotInfoProto.getVolumeName()).setBucketName(snapshotInfoProto.getBucketName()).setSnapshotStatus(SnapshotStatus.valueOf(snapshotInfoProto.getSnapshotStatus())).setCreationTime(snapshotInfoProto.getCreationTime()).setDeletionTime(snapshotInfoProto.getDeletionTime());
        if (snapshotInfoProto.hasPathPreviousSnapshotID()) {
            osib.setPathPreviousSnapshotId(HddsUtils.fromProtobuf((HddsProtos.UUID)snapshotInfoProto.getPathPreviousSnapshotID()));
        }
        if (snapshotInfoProto.hasGlobalPreviousSnapshotID()) {
            osib.setGlobalPreviousSnapshotId(HddsUtils.fromProtobuf((HddsProtos.UUID)snapshotInfoProto.getGlobalPreviousSnapshotID()));
        }
        if (snapshotInfoProto.hasDeepClean()) {
            osib.setDeepClean(snapshotInfoProto.getDeepClean());
        }
        if (snapshotInfoProto.hasSstFiltered()) {
            osib.setSstFiltered(snapshotInfoProto.getSstFiltered());
        }
        if (snapshotInfoProto.hasReferencedSize()) {
            osib.setReferencedSize(snapshotInfoProto.getReferencedSize());
        }
        if (snapshotInfoProto.hasReferencedReplicatedSize()) {
            osib.setReferencedReplicatedSize(snapshotInfoProto.getReferencedReplicatedSize());
        }
        if (snapshotInfoProto.hasExclusiveSize()) {
            osib.setExclusiveSize(snapshotInfoProto.getExclusiveSize());
        }
        if (snapshotInfoProto.hasExclusiveReplicatedSize()) {
            osib.setExclusiveReplicatedSize(snapshotInfoProto.getExclusiveReplicatedSize());
        }
        osib.setSnapshotPath(snapshotInfoProto.getSnapshotPath()).setCheckpointDir(snapshotInfoProto.getCheckpointDir()).setDbTxSequenceNumber(snapshotInfoProto.getDbTxSequenceNumber());
        return osib.build();
    }

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.getVolumeName());
        auditMap.put("bucket", this.getBucketName());
        auditMap.put("snapshotName", this.name);
        return auditMap;
    }

    public static String getCheckpointDirName(UUID snapshotId) {
        Objects.requireNonNull(snapshotId, "SnapshotId is needed to create checkpoint directory");
        return SEPARATOR + snapshotId;
    }

    public String getCheckpointDirName() {
        return SnapshotInfo.getCheckpointDirName(this.getSnapshotId());
    }

    public long getDbTxSequenceNumber() {
        return this.dbTxSequenceNumber;
    }

    public void setDbTxSequenceNumber(long dbTxSequenceNumber) {
        this.dbTxSequenceNumber = dbTxSequenceNumber;
    }

    public String getTableKey() {
        return SnapshotInfo.getTableKey(this.volumeName, this.bucketName, this.name);
    }

    public static String getTableKey(String volumeName, String bucketName, String snapshotName) {
        return "/" + volumeName + "/" + bucketName + "/" + snapshotName;
    }

    public void setReferencedSize(long referencedSize) {
        this.referencedSize = referencedSize;
    }

    public long getReferencedSize() {
        return this.referencedSize;
    }

    public void setReferencedReplicatedSize(long referencedReplicatedSize) {
        this.referencedReplicatedSize = referencedReplicatedSize;
    }

    public long getReferencedReplicatedSize() {
        return this.referencedReplicatedSize;
    }

    public void setExclusiveSize(long exclusiveSize) {
        this.exclusiveSize = exclusiveSize;
    }

    public long getExclusiveSize() {
        return this.exclusiveSize;
    }

    public void setExclusiveReplicatedSize(long exclusiveReplicatedSize) {
        this.exclusiveReplicatedSize = exclusiveReplicatedSize;
    }

    public long getExclusiveReplicatedSize() {
        return this.exclusiveReplicatedSize;
    }

    @VisibleForTesting
    public static String generateName(long initialTime) {
        String timePattern = "yyyyMMdd-HHmmss.SSS";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(timePattern);
        Instant instant = Instant.ofEpochMilli(initialTime);
        return "s" + formatter.format(ZonedDateTime.ofInstant(instant, ZoneId.of("UTC")));
    }

    public static SnapshotInfo newInstance(String volumeName, String bucketName, String snapshotName, UUID snapshotId, long creationTime) {
        Builder builder = new Builder();
        if (StringUtils.isBlank((CharSequence)snapshotName)) {
            snapshotName = SnapshotInfo.generateName(creationTime);
        }
        builder.setSnapshotId(snapshotId).setName(snapshotName).setCreationTime(creationTime).setDeletionTime(-1L).setPathPreviousSnapshotId(INITIAL_SNAPSHOT_ID).setGlobalPreviousSnapshotId(INITIAL_SNAPSHOT_ID).setSnapshotPath(volumeName + "/" + bucketName).setVolumeName(volumeName).setBucketName(bucketName).setDeepClean(true);
        if (snapshotId != null) {
            builder.setCheckpointDir(SnapshotInfo.getCheckpointDirName(snapshotId));
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotInfo that = (SnapshotInfo)o;
        return this.creationTime == that.creationTime && this.deletionTime == that.deletionTime && this.snapshotId.equals(that.snapshotId) && this.name.equals(that.name) && this.volumeName.equals(that.volumeName) && this.bucketName.equals(that.bucketName) && this.snapshotStatus == that.snapshotStatus && Objects.equals(this.pathPreviousSnapshotId, that.pathPreviousSnapshotId) && Objects.equals(this.globalPreviousSnapshotId, that.globalPreviousSnapshotId) && this.snapshotPath.equals(that.snapshotPath) && this.checkpointDir.equals(that.checkpointDir) && this.deepClean == that.deepClean && this.sstFiltered == that.sstFiltered && this.referencedSize == that.referencedSize && this.referencedReplicatedSize == that.referencedReplicatedSize && this.exclusiveSize == that.exclusiveSize && this.exclusiveReplicatedSize == that.exclusiveReplicatedSize;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshotId, this.name, this.volumeName, this.bucketName, this.snapshotStatus, this.creationTime, this.deletionTime, this.pathPreviousSnapshotId, this.globalPreviousSnapshotId, this.snapshotPath, this.checkpointDir, this.deepClean, this.sstFiltered, this.referencedSize, this.referencedReplicatedSize, this.exclusiveSize, this.exclusiveReplicatedSize});
    }

    public SnapshotInfo copyObject() {
        return new Builder().setSnapshotId(this.snapshotId).setName(this.name).setVolumeName(this.volumeName).setBucketName(this.bucketName).setSnapshotStatus(this.snapshotStatus).setCreationTime(this.creationTime).setDeletionTime(this.deletionTime).setPathPreviousSnapshotId(this.pathPreviousSnapshotId).setGlobalPreviousSnapshotId(this.globalPreviousSnapshotId).setSnapshotPath(this.snapshotPath).setCheckpointDir(this.checkpointDir).setDbTxSequenceNumber(this.dbTxSequenceNumber).setDeepClean(this.deepClean).setSstFiltered(this.sstFiltered).setReferencedSize(this.referencedSize).setReferencedReplicatedSize(this.referencedReplicatedSize).setExclusiveSize(this.exclusiveSize).setExclusiveReplicatedSize(this.exclusiveReplicatedSize).build();
    }

    public static class Builder {
        private UUID snapshotId;
        private String name;
        private String volumeName;
        private String bucketName;
        private SnapshotStatus snapshotStatus = SnapshotStatus.DEFAULT;
        private long creationTime;
        private long deletionTime;
        private UUID pathPreviousSnapshotId;
        private UUID globalPreviousSnapshotId;
        private String snapshotPath;
        private String checkpointDir;
        private long dbTxSequenceNumber;
        private boolean deepClean;
        private boolean sstFiltered;
        private long referencedSize;
        private long referencedReplicatedSize;
        private long exclusiveSize;
        private long exclusiveReplicatedSize;

        public Builder setSnapshotId(UUID snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setVolumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public Builder setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder setSnapshotStatus(SnapshotStatus snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
            return this;
        }

        public Builder setCreationTime(long crTime) {
            this.creationTime = crTime;
            return this;
        }

        public Builder setDeletionTime(long delTime) {
            this.deletionTime = delTime;
            return this;
        }

        public Builder setPathPreviousSnapshotId(UUID pathPreviousSnapshotId) {
            this.pathPreviousSnapshotId = pathPreviousSnapshotId;
            return this;
        }

        public Builder setGlobalPreviousSnapshotId(UUID globalPreviousSnapshotId) {
            this.globalPreviousSnapshotId = globalPreviousSnapshotId;
            return this;
        }

        public Builder setSnapshotPath(String snapshotPath) {
            this.snapshotPath = snapshotPath;
            return this;
        }

        public Builder setCheckpointDir(String checkpointDir) {
            this.checkpointDir = checkpointDir;
            return this;
        }

        public Builder setDbTxSequenceNumber(long dbTxSequenceNumber) {
            this.dbTxSequenceNumber = dbTxSequenceNumber;
            return this;
        }

        public Builder setDeepClean(boolean deepClean) {
            this.deepClean = deepClean;
            return this;
        }

        public Builder setSstFiltered(boolean sstFiltered) {
            this.sstFiltered = sstFiltered;
            return this;
        }

        public Builder setReferencedSize(long referencedSize) {
            this.referencedSize = referencedSize;
            return this;
        }

        public Builder setReferencedReplicatedSize(long referencedReplicatedSize) {
            this.referencedReplicatedSize = referencedReplicatedSize;
            return this;
        }

        public Builder setExclusiveSize(long exclusiveSize) {
            this.exclusiveSize = exclusiveSize;
            return this;
        }

        public Builder setExclusiveReplicatedSize(long exclusiveReplicatedSize) {
            this.exclusiveReplicatedSize = exclusiveReplicatedSize;
            return this;
        }

        public SnapshotInfo build() {
            Preconditions.checkNotNull((Object)this.name);
            return new SnapshotInfo(this.snapshotId, this.name, this.volumeName, this.bucketName, this.snapshotStatus, this.creationTime, this.deletionTime, this.pathPreviousSnapshotId, this.globalPreviousSnapshotId, this.snapshotPath, this.checkpointDir, this.dbTxSequenceNumber, this.deepClean, this.sstFiltered, this.referencedSize, this.referencedReplicatedSize, this.exclusiveSize, this.exclusiveReplicatedSize);
        }
    }

    public static enum SnapshotStatus {
        SNAPSHOT_ACTIVE,
        SNAPSHOT_DELETED;

        public static final SnapshotStatus DEFAULT;

        public OzoneManagerProtocolProtos.SnapshotStatusProto toProto() {
            switch (this) {
                case SNAPSHOT_ACTIVE: {
                    return OzoneManagerProtocolProtos.SnapshotStatusProto.SNAPSHOT_ACTIVE;
                }
                case SNAPSHOT_DELETED: {
                    return OzoneManagerProtocolProtos.SnapshotStatusProto.SNAPSHOT_DELETED;
                }
            }
            throw new IllegalStateException("BUG: missing valid SnapshotStatus, found status=" + (Object)((Object)this));
        }

        public static SnapshotStatus valueOf(OzoneManagerProtocolProtos.SnapshotStatusProto status) {
            switch (status) {
                case SNAPSHOT_ACTIVE: {
                    return SNAPSHOT_ACTIVE;
                }
                case SNAPSHOT_DELETED: {
                    return SNAPSHOT_DELETED;
                }
            }
            throw new IllegalStateException("BUG: missing valid SnapshotStatus, found status=" + status);
        }

        static {
            DEFAULT = SNAPSHOT_ACTIVE;
        }
    }
}

