/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.IOmMetadataReader;
import org.apache.hadoop.ozone.om.helpers.DBUpdates;
import org.apache.hadoop.ozone.om.helpers.DeleteTenantState;
import org.apache.hadoop.ozone.om.helpers.KeyInfoWithVolumeContext;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDeleteKeys;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmRenameKeys;
import org.apache.hadoop.ozone.om.helpers.OmTenantArgs;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatusLight;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.S3VolumeContext;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.helpers.SnapshotDiffJob;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.helpers.TenantStateList;
import org.apache.hadoop.ozone.om.helpers.TenantUserInfoValue;
import org.apache.hadoop.ozone.om.helpers.TenantUserList;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerSecurityProtocol;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneDelegationTokenSelector;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.snapshot.CancelSnapshotDiffResponse;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.token.TokenInfo;

@KerberosInfo(serverPrincipal="ozone.om.kerberos.principal")
@TokenInfo(value=OzoneDelegationTokenSelector.class)
public interface OzoneManagerProtocol
extends IOmMetadataReader,
OzoneManagerSecurityProtocol,
Closeable {
    public static final long versionID = 1L;

    default public void createVolume(OmVolumeArgs args) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public boolean setOwner(String volume, String owner) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public void setQuota(String volume, long quotaInNamespace, long quotaInBytes) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public boolean checkVolumeAccess(String volume, OzoneManagerProtocolProtos.OzoneAclInfo userAcl) throws IOException {
        throw new UnsupportedOperationException("This operation is not supported.");
    }

    public OmVolumeArgs getVolumeInfo(String var1) throws IOException;

    default public void deleteVolume(String volume) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    public List<OmVolumeArgs> listVolumeByUser(String var1, String var2, String var3, int var4) throws IOException;

    public List<OmVolumeArgs> listAllVolumes(String var1, String var2, int var3) throws IOException;

    default public void createBucket(OmBucketInfo bucketInfo) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    public OmBucketInfo getBucketInfo(String var1, String var2) throws IOException;

    default public void setBucketProperty(OmBucketArgs args) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public boolean setBucketOwner(OmBucketArgs args) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public OpenKeySession openKey(OmKeyArgs args) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public void commitKey(OmKeyArgs args, long clientID) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public void hsyncKey(OmKeyArgs args, long clientID) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public OmKeyLocationInfo allocateBlock(OmKeyArgs args, long clientID, ExcludeList excludeList) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    @Override
    @Deprecated
    public OmKeyInfo lookupKey(OmKeyArgs var1) throws IOException;

    @Override
    public KeyInfoWithVolumeContext getKeyInfo(OmKeyArgs var1, boolean var2) throws IOException;

    default public void renameKey(OmKeyArgs args, String toKeyName) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public void renameKeys(OmRenameKeys omRenameKeys) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public void deleteKey(OmKeyArgs args) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public void deleteKeys(OmDeleteKeys deleteKeys) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public void deleteBucket(String volume, String bucket) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    public List<OmBucketInfo> listBuckets(String var1, String var2, String var3, int var4, boolean var5) throws IOException;

    public List<ServiceInfo> getServiceList() throws IOException;

    public ServiceInfoEx getServiceInfo() throws IOException;

    public void transferLeadership(String var1) throws IOException;

    public boolean triggerRangerBGSync(boolean var1) throws IOException;

    public UpgradeFinalizer.StatusAndMessages finalizeUpgrade(String var1) throws IOException;

    public UpgradeFinalizer.StatusAndMessages queryUpgradeFinalizationProgress(String var1, boolean var2, boolean var3) throws IOException;

    default public OmMultipartInfo initiateMultipartUpload(OmKeyArgs keyArgs) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public OmMultipartCommitUploadPartInfo commitMultipartUploadPart(OmKeyArgs omKeyArgs, long clientID) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public OmMultipartUploadCompleteInfo completeMultipartUpload(OmKeyArgs omKeyArgs, OmMultipartUploadCompleteList multipartUploadList) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public void abortMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    public OmMultipartUploadListParts listParts(String var1, String var2, String var3, String var4, int var5, int var6) throws IOException;

    public OmMultipartUploadList listMultipartUploads(String var1, String var2, String var3) throws IOException;

    @Nonnull
    default public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public S3SecretValue getS3Secret(String kerberosID, boolean createIfNotExist) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach");
    }

    default public S3SecretValue setS3Secret(String accessId, String secretKey) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach");
    }

    default public void revokeS3Secret(String kerberosID) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public void createTenant(OmTenantArgs omTenantArgs) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach");
    }

    default public DeleteTenantState deleteTenant(String tenantId) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach");
    }

    default public S3SecretValue tenantAssignUserAccessId(String username, String tenantId, String accessId) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach");
    }

    public S3VolumeContext getS3VolumeContext() throws IOException;

    default public void tenantRevokeUserAccessId(String accessId) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach");
    }

    default public String createSnapshot(String volumeName, String bucketName, String snapshotName) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented");
    }

    default public void deleteSnapshot(String volumeName, String bucketName, String snapshotName) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented");
    }

    default public SnapshotInfo getSnapshotInfo(String volumeName, String bucketName, String snapshotName) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented");
    }

    default public String printCompactionLogDag(String fileNamePrefix, String graphType) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented");
    }

    default public List<SnapshotInfo> listSnapshot(String volumeName, String bucketName, String snapshotPrefix, String prevSnapshot, int maxListResult) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented");
    }

    default public SnapshotDiffResponse snapshotDiff(String volumeName, String bucketName, String fromSnapshot, String toSnapshot, String token, int pageSize, boolean forceFullDiff, boolean disableNativeDiff) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented");
    }

    default public CancelSnapshotDiffResponse cancelSnapshotDiff(String volumeName, String bucketName, String fromSnapshot, String toSnapshot) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented");
    }

    default public List<SnapshotDiffJob> listSnapshotDiffJobs(String volumeName, String bucketName, String jobStatus, boolean listAll) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented");
    }

    default public void tenantAssignAdmin(String accessId, String tenantId, boolean delegated) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach");
    }

    default public void tenantRevokeAdmin(String accessId, String tenantId) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach");
    }

    public TenantUserInfoValue tenantGetUserInfo(String var1) throws IOException;

    public TenantUserList listUsersInTenant(String var1, String var2) throws IOException;

    public TenantStateList listTenant() throws IOException;

    default public void createDirectory(OmKeyArgs args) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public OpenKeySession createFile(OmKeyArgs keyArgs, boolean overWrite, boolean recursive) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    @Override
    @Deprecated
    public OmKeyInfo lookupFile(OmKeyArgs var1) throws IOException;

    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs var1, boolean var2, String var3, long var4) throws IOException;

    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs var1, boolean var2, String var3, long var4, boolean var6) throws IOException;

    @Override
    public List<OzoneFileStatusLight> listStatusLight(OmKeyArgs var1, boolean var2, String var3, long var4, boolean var6) throws IOException;

    default public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    default public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        throw new UnsupportedOperationException("OzoneManager does not require this to be implemented, as write requests use a new approach.");
    }

    public DBUpdates getDBUpdates(OzoneManagerProtocolProtos.DBUpdatesRequest var1) throws IOException;

    public List<RepeatedOmKeyInfo> listTrash(String var1, String var2, String var3, String var4, int var5) throws IOException;

    default public boolean recoverTrash(String volumeName, String bucketName, String keyName, String destinationBucket) throws IOException {
        return false;
    }

    default public long prepareOzoneManager(long txnApplyWaitTimeoutSeconds, long txnApplyCheckIntervalSeconds) throws IOException {
        return -1L;
    }

    default public OzoneManagerProtocolProtos.PrepareStatusResponse getOzoneManagerPrepareStatus(long txnId) throws IOException {
        return OzoneManagerProtocolProtos.PrepareStatusResponse.newBuilder().setCurrentTxnIndex(-1L).setStatus(OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus.NOT_PREPARED).build();
    }

    default public OzoneManagerProtocolProtos.CancelPrepareResponse cancelOzoneManagerPrepare() throws IOException {
        return OzoneManagerProtocolProtos.CancelPrepareResponse.newBuilder().build();
    }

    public OzoneManagerProtocolProtos.EchoRPCResponse echoRPCReq(byte[] var1, int var2, boolean var3) throws IOException;

    public boolean recoverLease(String var1, String var2, String var3) throws IOException;

    public void setTimes(OmKeyArgs var1, long var2, long var4) throws IOException;

    public UUID refetchSecretKey() throws IOException;

    public boolean setSafeMode(SafeModeAction var1, boolean var2) throws IOException;
}

