/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.MonitoredTaskImpl;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TaskGroup
extends MonitoredTaskImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TaskGroup.class);
    private final ConcurrentLinkedDeque<MonitoredTask> tasks = new ConcurrentLinkedDeque();
    private boolean ignoreSubTasksInTaskMonitor;
    private final MonitoredTask delegate;

    public TaskGroup(boolean ignoreSubTasksInTaskMonitor, String description) {
        super(true, description);
        this.ignoreSubTasksInTaskMonitor = ignoreSubTasksInTaskMonitor;
        this.delegate = TaskMonitor.get().createStatus(description, false, true);
    }

    public synchronized MonitoredTask addTask(String description) {
        return this.addTask(description, true);
    }

    public synchronized MonitoredTask addTask(String description, boolean withCompleteLast) {
        MonitoredTask previousTask;
        if (withCompleteLast && (previousTask = this.tasks.peekLast()) != null && previousTask.getState() != MonitoredTask.State.COMPLETE && previousTask.getState() != MonitoredTask.State.ABORTED) {
            previousTask.markComplete("Completed");
        }
        MonitoredTask task = TaskMonitor.get().createStatus(description, this.ignoreSubTasksInTaskMonitor, true);
        this.setStatus(description);
        this.tasks.addLast(task);
        this.delegate.setStatus(description);
        return task;
    }

    public synchronized Collection<MonitoredTask> getTasks() {
        return Collections.unmodifiableCollection(this.tasks);
    }

    @Override
    public synchronized void abort(String msg) {
        this.setStatus(msg);
        this.setState(MonitoredTask.State.ABORTED);
        for (MonitoredTask task : this.tasks) {
            if (task.getState() == MonitoredTask.State.COMPLETE || task.getState() == MonitoredTask.State.ABORTED) continue;
            task.abort(msg);
        }
        this.delegate.abort(msg);
    }

    @Override
    public synchronized void markComplete(String msg) {
        this.setState(MonitoredTask.State.COMPLETE);
        this.setStatus(msg);
        if (this.tasks.getLast() != null) {
            this.tasks.getLast().markComplete(msg);
        }
        this.delegate.markComplete(msg);
    }

    @Override
    public synchronized void cleanup() {
        this.tasks.clear();
    }
}

