/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MemStoreSnapshot {
    private final long id;
    private final int cellsCount;
    private final MemStoreSize memStoreSize;
    private final TimeRangeTracker timeRangeTracker;
    private final boolean tagsPresent;
    private final ImmutableSegment snapshotImmutableSegment;

    public MemStoreSnapshot(long id, ImmutableSegment snapshot) {
        this.id = id;
        this.cellsCount = snapshot.getCellsCount();
        this.memStoreSize = snapshot.getMemStoreSize();
        this.timeRangeTracker = snapshot.getTimeRangeTracker();
        this.tagsPresent = snapshot.isTagsPresent();
        this.snapshotImmutableSegment = snapshot;
    }

    public long getId() {
        return this.id;
    }

    public int getCellsCount() {
        return this.cellsCount;
    }

    public long getDataSize() {
        return this.memStoreSize.getDataSize();
    }

    public MemStoreSize getMemStoreSize() {
        return this.memStoreSize;
    }

    public TimeRangeTracker getTimeRangeTracker() {
        return this.timeRangeTracker;
    }

    public List<KeyValueScanner> getScanners() {
        return this.snapshotImmutableSegment.getSnapshotScanners();
    }

    public boolean isTagsPresent() {
        return this.tagsPresent;
    }
}

