/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hbase.regionserver.wal.AbstractProtobufWALReader;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALStreamReader;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.Parser;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ProtobufWALStreamReader
extends AbstractProtobufWALReader
implements WALStreamReader,
AbstractFSWALProvider.Initializer {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufWALStreamReader.class);

    @Override
    public WAL.Entry next(WAL.Entry reuse) throws IOException {
        int actualCells;
        WALProtos.WALKey walKey;
        long originalPosition = this.getPosition();
        if (this.reachWALEditsStopOffset(originalPosition)) {
            return null;
        }
        try {
            walKey = (WALProtos.WALKey)ProtobufUtil.parseDelimitedFrom((InputStream)this.inputStream, (Parser)WALProtos.WALKey.parser());
        }
        catch (InvalidProtocolBufferException e) {
            if (ProtobufUtil.isEOF((InvalidProtocolBufferException)e) || this.isWALTrailer(originalPosition)) {
                throw (EOFException)new EOFException("EOF while reading WALKey, originalPosition=" + originalPosition + ", currentPosition=" + this.inputStream.getPos()).initCause(e);
            }
            throw (IOException)new IOException("Error while reading WALKey, originalPosition=" + originalPosition + ", currentPosition=" + this.inputStream.getPos()).initCause(e);
        }
        WAL.Entry entry = reuse;
        if (entry == null) {
            entry = new WAL.Entry();
        }
        entry.getKey().readFieldsFromPb(walKey, this.byteStringUncompressor);
        if (!walKey.hasFollowingKvCount() || walKey.getFollowingKvCount() == 0) {
            LOG.trace("WALKey has no KVs that follow it; trying the next one. current offset={}", (Object)this.inputStream.getPos());
            return entry;
        }
        int expectedCells = walKey.getFollowingKvCount();
        long posBefore = this.getPosition();
        try {
            actualCells = entry.getEdit().readFromCells(this.cellDecoder, expectedCells);
        }
        catch (Exception e) {
            String message = " while reading " + expectedCells + " WAL KVs; started reading at " + posBefore + " and read up to " + this.getPositionQuietly();
            IOException realEofEx = this.extractHiddenEof(e);
            if (realEofEx != null) {
                throw (EOFException)new EOFException("EOF " + message).initCause(realEofEx);
            }
            throw new IOException("Error " + message, e);
        }
        if (expectedCells != actualCells) {
            throw new EOFException("Only read " + actualCells + " cells, expected " + expectedCells + "; started reading at " + posBefore + " and read up to " + this.getPositionQuietly());
        }
        long posAfter = this.inputStream.getPos();
        if (this.trailerPresent && posAfter > this.walEditsStopOffset) {
            LOG.error("Read WALTrailer while reading WALEdits. wal: {}, inputStream.getPos(): {}, walEditsStopOffset: {}", new Object[]{this.path, posAfter, this.walEditsStopOffset});
            throw new EOFException("Read WALTrailer while reading WALEdits; started reading at " + posBefore + " and read up to " + posAfter);
        }
        return entry;
    }

    @Override
    protected InputStream getCellCodecInputStream(FSDataInputStream stream) {
        return stream;
    }

    @Override
    protected void skipTo(long position) throws IOException {
        long pos;
        WAL.Entry entry = new WAL.Entry();
        do {
            if ((entry = this.next(entry)) == null) {
                throw new EOFException("Can not skip to the given position " + position + " as we have already reached the end of file");
            }
            pos = this.inputStream.getPos();
            if (pos <= position) continue;
            throw new IOException("Can not skip to the given position " + position + ", stopped at " + pos + " which is already beyond the give position, malformed WAL?");
        } while (pos != position);
    }
}

