/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerImpl;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.regionserver.PeerProcedureHandler;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class PeerProcedureHandlerImpl
implements PeerProcedureHandler {
    private final ReplicationSourceManager replicationSourceManager;
    private final KeyLocker<String> peersLock = new KeyLocker();

    public PeerProcedureHandlerImpl(ReplicationSourceManager replicationSourceManager) {
        this.replicationSourceManager = replicationSourceManager;
    }

    @Override
    public void addPeer(String peerId) throws IOException {
        ReentrantLock peerLock = this.peersLock.acquireLock((Object)peerId);
        try {
            this.replicationSourceManager.addPeer(peerId);
        }
        finally {
            peerLock.unlock();
        }
    }

    @Override
    public void removePeer(String peerId) throws IOException {
        ReentrantLock peerLock = this.peersLock.acquireLock((Object)peerId);
        try {
            if (this.replicationSourceManager.getReplicationPeers().getPeer(peerId) != null) {
                this.replicationSourceManager.removePeer(peerId);
            }
        }
        finally {
            peerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPeerState(String peerId) throws ReplicationException, IOException {
        ReentrantLock peerLock = this.peersLock.acquireLock((Object)peerId);
        ReplicationPeerImpl peer = null;
        ReplicationPeer.PeerState oldState = null;
        boolean success = false;
        try {
            peer = this.replicationSourceManager.getReplicationPeers().getPeer(peerId);
            if (peer == null) {
                throw new ReplicationException("Peer with id=" + peerId + " is not cached.");
            }
            oldState = peer.getPeerState();
            ReplicationPeer.PeerState newState = this.replicationSourceManager.getReplicationPeers().refreshPeerState(peerId);
            if (oldState.equals((Object)ReplicationPeer.PeerState.ENABLED) && newState.equals((Object)ReplicationPeer.PeerState.DISABLED)) {
                this.replicationSourceManager.refreshSources(peerId);
            }
            success = true;
        }
        finally {
            if (!success && peer != null) {
                peer.setPeerState(oldState.equals((Object)ReplicationPeer.PeerState.ENABLED));
            }
            peerLock.unlock();
        }
    }

    @Override
    public void enablePeer(String peerId) throws ReplicationException, IOException {
        this.refreshPeerState(peerId);
    }

    @Override
    public void disablePeer(String peerId) throws ReplicationException, IOException {
        this.refreshPeerState(peerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePeerConfig(String peerId) throws ReplicationException, IOException {
        ReentrantLock peerLock = this.peersLock.acquireLock((Object)peerId);
        ReplicationPeers peers = this.replicationSourceManager.getReplicationPeers();
        ReplicationPeerImpl peer = null;
        ReplicationPeerConfig oldConfig = null;
        ReplicationPeer.PeerState oldState = null;
        boolean success = false;
        try {
            peer = peers.getPeer(peerId);
            if (peer == null) {
                throw new ReplicationException("Peer with id=" + peerId + " is not cached.");
            }
            oldConfig = peer.getPeerConfig();
            oldState = peer.getPeerState();
            ReplicationPeerConfig newConfig = peers.refreshPeerConfig(peerId);
            ReplicationPeer.PeerState newState = peers.refreshPeerState(peerId);
            if (!ReplicationUtils.isNamespacesAndTableCFsEqual((ReplicationPeerConfig)oldConfig, (ReplicationPeerConfig)newConfig) || oldConfig.isSerial() != newConfig.isSerial() || oldState.equals((Object)ReplicationPeer.PeerState.ENABLED) && newState.equals((Object)ReplicationPeer.PeerState.DISABLED)) {
                this.replicationSourceManager.refreshSources(peerId);
            }
            success = true;
        }
        finally {
            if (!success && peer != null) {
                peer.setPeerConfig(oldConfig);
                peer.setPeerState(oldState.equals((Object)ReplicationPeer.PeerState.ENABLED));
            }
            peerLock.unlock();
        }
    }

    @Override
    public void claimReplicationQueue(ServerName crashedServer, String queue) throws ReplicationException, IOException {
        this.replicationSourceManager.claimQueue(crashedServer, queue);
    }
}

