/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import com.google.errorprone.annotations.Immutable;
import java.util.Objects;

@Immutable
public final class Location {
    private final int lineNumber;
    private final int columnNumber;

    public Location(int lineNumber, int columnNumber) {
        if (lineNumber < 1) {
            throw new IllegalArgumentException("lineNumber must be at least one");
        }
        if (columnNumber < 1) {
            throw new IllegalArgumentException("columnNumber must be at least one");
        }
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Location)) return false;
        Location other = (Location)o;
        if (this.lineNumber != other.lineNumber) return false;
        if (this.columnNumber != other.columnNumber) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.lineNumber, this.columnNumber);
    }

    public String toString() {
        return this.lineNumber + ":" + this.columnNumber;
    }
}

