/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.LongArrayBlock;

public class LongArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "LONG_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        LongArrayBlock longArrayBlock = (LongArrayBlock)block;
        int positionCount = longArrayBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, longArrayBlock);
        if (!longArrayBlock.mayHaveNull()) {
            sliceOutput.writeLongs(longArrayBlock.getRawValues(), longArrayBlock.getRawValuesOffset(), longArrayBlock.getPositionCount());
        } else {
            long[] valuesWithoutNull = new long[positionCount];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                valuesWithoutNull[nonNullPositionCount] = longArrayBlock.getLong(i);
                if (longArrayBlock.isNull(i)) continue;
                ++nonNullPositionCount;
            }
            sliceOutput.writeInt(nonNullPositionCount);
            sliceOutput.writeLongs(valuesWithoutNull, 0, nonNullPositionCount);
        }
    }

    @Override
    public LongArrayBlock readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int i;
        int positionCount = sliceInput.readInt();
        byte[] valueIsNullPacked = EncoderUtil.retrieveNullBits(sliceInput, positionCount);
        long[] values = new long[positionCount];
        if (valueIsNullPacked == null) {
            sliceInput.readLongs(values);
            return new LongArrayBlock(0, positionCount, null, values);
        }
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(valueIsNullPacked, positionCount);
        int nonNullPositionCount = sliceInput.readInt();
        sliceInput.readLongs(values, 0, nonNullPositionCount);
        int position = nonNullPositionCount - 1;
        for (i = positionCount - 1; i >= (positionCount & 0xFFFFFFF8) && position >= 0; --i) {
            values[i] = values[position];
            if (valueIsNull[i]) continue;
            --position;
        }
        for (i = (positionCount & 0xFFFFFFF8) - 8; i >= 0 && position >= 0; i -= 8) {
            byte packed = valueIsNullPacked[i >>> 3];
            if (packed == 0) {
                System.arraycopy(values, position - 7, values, i, 8);
                position -= 8;
                continue;
            }
            if (packed == -1) continue;
            for (int j = i + 7; j >= i && position >= 0; --j) {
                values[j] = values[position];
                if (valueIsNull[j]) continue;
                --position;
            }
        }
        return new LongArrayBlock(0, positionCount, valueIsNull, values);
    }
}

