/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.Experimental;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Preconditions;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@Experimental(eta="2024-01-01")
public record RelationColumnsMetadata(SchemaTableName name, Optional<List<ConnectorMaterializedViewDefinition.Column>> materializedViewColumns, Optional<List<ConnectorViewDefinition.ViewColumn>> viewColumns, Optional<List<ColumnMetadata>> tableColumns, boolean redirected) {
    public RelationColumnsMetadata {
        Objects.requireNonNull(name, "name is null");
        materializedViewColumns = materializedViewColumns.map(List::copyOf);
        viewColumns = viewColumns.map(List::copyOf);
        tableColumns = tableColumns.map(List::copyOf);
        Preconditions.checkArgument(Stream.of(materializedViewColumns.isPresent(), viewColumns.isPresent(), tableColumns.isPresent(), redirected).filter(value -> value).count() == 1L, "Expected exactly one to be true. Use factory methods to ensure correct instantiation", new Object[0]);
    }

    public static RelationColumnsMetadata forMaterializedView(SchemaTableName name, List<ConnectorMaterializedViewDefinition.Column> columns) {
        return new RelationColumnsMetadata(name, Optional.of(columns), Optional.empty(), Optional.empty(), false);
    }

    public static RelationColumnsMetadata forView(SchemaTableName name, List<ConnectorViewDefinition.ViewColumn> columns) {
        return new RelationColumnsMetadata(name, Optional.empty(), Optional.of(columns), Optional.empty(), false);
    }

    public static RelationColumnsMetadata forTable(SchemaTableName name, List<ColumnMetadata> columns) {
        return new RelationColumnsMetadata(name, Optional.empty(), Optional.empty(), Optional.of(columns), false);
    }

    public static RelationColumnsMetadata forRedirectedTable(SchemaTableName name) {
        return new RelationColumnsMetadata(name, Optional.empty(), Optional.empty(), Optional.empty(), true);
    }
}

