/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.jackson.datatype.joda.ser;

import io.prestosql.jdbc.$internal.jackson.annotation.JsonFormat;
import io.prestosql.jdbc.$internal.jackson.core.JsonGenerator;
import io.prestosql.jdbc.$internal.jackson.databind.BeanProperty;
import io.prestosql.jdbc.$internal.jackson.databind.JavaType;
import io.prestosql.jdbc.$internal.jackson.databind.JsonMappingException;
import io.prestosql.jdbc.$internal.jackson.databind.JsonNode;
import io.prestosql.jdbc.$internal.jackson.databind.JsonSerializer;
import io.prestosql.jdbc.$internal.jackson.databind.SerializerProvider;
import io.prestosql.jdbc.$internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.prestosql.jdbc.$internal.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import io.prestosql.jdbc.$internal.jackson.databind.ser.ContextualSerializer;
import io.prestosql.jdbc.$internal.jackson.datatype.joda.cfg.FormatConfig;
import io.prestosql.jdbc.$internal.jackson.datatype.joda.cfg.JacksonJodaPeriodFormat;
import io.prestosql.jdbc.$internal.jackson.datatype.joda.ser.JodaSerializerBase;
import io.prestosql.jdbc.$internal.joda.time.ReadablePeriod;
import java.io.IOException;
import java.lang.reflect.Type;

public class PeriodSerializer
extends JodaSerializerBase<ReadablePeriod>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final JacksonJodaPeriodFormat _format;

    public PeriodSerializer() {
        this(FormatConfig.DEFAULT_PERIOD_FORMAT);
    }

    protected PeriodSerializer(JacksonJodaPeriodFormat format) {
        super(ReadablePeriod.class);
        this._format = format;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value ann;
        if (property != null && (ann = this.findFormatOverrides(prov, property, this.handledType())) != null) {
            JacksonJodaPeriodFormat format = this._format;
            Boolean useTimestamp = ann.getShape().isNumeric() ? Boolean.TRUE : (ann.getShape() == JsonFormat.Shape.STRING ? Boolean.FALSE : (ann.getShape() == JsonFormat.Shape.ARRAY ? Boolean.TRUE : null));
            if (useTimestamp != null) {
                format = format.withUseTimestamp(useTimestamp);
            }
            format = format.withFormat(ann.getPattern().trim());
            if ((format = format.withLocale(ann.getLocale())) != this._format) {
                return new PeriodSerializer(format);
            }
        }
        return this;
    }

    @Override
    public void serialize(ReadablePeriod value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(this._format.createFormatter(provider).print(value));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
        if (v2 != null) {
            // empty if block
        }
    }
}

