/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ozone.client.io.ByteBufferOutputStream;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.protocol.exceptions.RaftRetryFailureException;

public abstract class AbstractDataStreamOutput
extends ByteBufferOutputStream {
    private final Map<Class<? extends Throwable>, RetryPolicy> retryPolicyMap;
    private int retryCount;
    private boolean isException;

    protected AbstractDataStreamOutput(Map<Class<? extends Throwable>, RetryPolicy> retryPolicyMap) {
        this.retryPolicyMap = retryPolicyMap;
        this.isException = false;
        this.retryCount = 0;
    }

    protected void resetRetryCount() {
        this.retryCount = 0;
    }

    protected boolean isException() {
        return this.isException;
    }

    protected boolean checkForRetryFailure(Throwable t) {
        return t instanceof RaftRetryFailureException || t instanceof AlreadyClosedException;
    }

    protected boolean checkIfContainerToExclude(Throwable t) {
        return t instanceof StorageContainerException;
    }

    protected void setExceptionAndThrow(IOException ioe) throws IOException {
        this.isException = true;
        throw ioe;
    }

    protected void handleRetry(IOException exception) throws IOException {
        RetryPolicy retryPolicy = this.retryPolicyMap.get(HddsClientUtils.checkForException(exception).getClass());
        if (retryPolicy == null) {
            retryPolicy = this.retryPolicyMap.get(Exception.class);
        }
        this.handleRetry(exception, retryPolicy);
    }

    protected void handleRetry(IOException exception, RetryPolicy retryPolicy) throws IOException {
        RetryPolicy.RetryAction action = null;
        try {
            action = retryPolicy.shouldRetry((Exception)exception, this.retryCount, 0, true);
        }
        catch (Exception e) {
            this.setExceptionAndThrow(new IOException(e));
        }
        if (action != null && action.action == RetryPolicy.RetryAction.RetryDecision.FAIL) {
            String msg = "";
            if (action.reason != null) {
                msg = "Retry request failed. " + action.reason;
            }
            this.setExceptionAndThrow(new IOException(msg, exception));
        }
        if (Thread.currentThread().isInterrupted()) {
            this.setExceptionAndThrow(exception);
        }
        Objects.requireNonNull(action);
        Preconditions.checkArgument((action.action == RetryPolicy.RetryAction.RetryDecision.RETRY ? 1 : 0) != 0);
        if (action.delayMillis > 0L) {
            try {
                Thread.sleep(action.delayMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                IOException ioe = (IOException)new InterruptedIOException("Interrupted: action=" + action + ", retry policy=" + retryPolicy).initCause(e);
                this.setExceptionAndThrow(ioe);
            }
        }
        ++this.retryCount;
    }
}

