/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.cache.ContextCache;
import org.springframework.test.context.cache.DefaultContextCache;
import org.springframework.util.Assert;

public class DefaultCacheAwareContextLoaderDelegate
implements CacheAwareContextLoaderDelegate {
    private static final Log logger = LogFactory.getLog(DefaultCacheAwareContextLoaderDelegate.class);
    static final ContextCache defaultContextCache = new DefaultContextCache();
    private final ContextCache contextCache;

    public DefaultCacheAwareContextLoaderDelegate() {
        this(defaultContextCache);
    }

    public DefaultCacheAwareContextLoaderDelegate(ContextCache contextCache) {
        Assert.notNull((Object)contextCache, (String)"ContextCache must not be null");
        this.contextCache = contextCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isContextLoaded(MergedContextConfiguration mergedContextConfiguration) {
        ContextCache contextCache = this.contextCache;
        synchronized (contextCache) {
            return this.contextCache.contains(mergedContextConfiguration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationContext loadContext(MergedContextConfiguration mergedContextConfiguration) {
        ContextCache contextCache = this.contextCache;
        synchronized (contextCache) {
            ApplicationContext context = this.contextCache.get(mergedContextConfiguration);
            if (context == null) {
                try {
                    context = this.loadContextInternal(mergedContextConfiguration);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Storing ApplicationContext [%s] in cache under key [%s]", System.identityHashCode(context), mergedContextConfiguration));
                    }
                    this.contextCache.put(mergedContextConfiguration, context);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to load ApplicationContext", ex);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Retrieved ApplicationContext [%s] from cache with key [%s]", System.identityHashCode(context), mergedContextConfiguration));
            }
            this.contextCache.logStatistics();
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeContext(MergedContextConfiguration mergedContextConfiguration, @Nullable DirtiesContext.HierarchyMode hierarchyMode) {
        ContextCache contextCache = this.contextCache;
        synchronized (contextCache) {
            this.contextCache.remove(mergedContextConfiguration, hierarchyMode);
        }
    }

    protected ContextCache getContextCache() {
        return this.contextCache;
    }

    protected ApplicationContext loadContextInternal(MergedContextConfiguration mergedContextConfiguration) throws Exception {
        ContextLoader contextLoader = mergedContextConfiguration.getContextLoader();
        Assert.notNull((Object)contextLoader, (String)"Cannot load an ApplicationContext with a NULL 'contextLoader'. Consider annotating your test class with @ContextConfiguration or @ContextHierarchy.");
        if (contextLoader instanceof SmartContextLoader) {
            return ((SmartContextLoader)contextLoader).loadContext(mergedContextConfiguration);
        }
        String[] locations = mergedContextConfiguration.getLocations();
        Assert.notNull((Object)locations, (String)"Cannot load an ApplicationContext with a NULL 'locations' array. Consider annotating your test class with @ContextConfiguration or @ContextHierarchy.");
        return contextLoader.loadContext(locations);
    }
}

