/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.logs.model.AnomalyDetectorStatus;
import com.amazonaws.services.logs.model.EvaluationFrequency;
import com.amazonaws.services.logs.model.transform.AnomalyDetectorMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AnomalyDetector
implements Serializable,
Cloneable,
StructuredPojo {
    private String anomalyDetectorArn;
    private String detectorName;
    private SdkInternalList<String> logGroupArnList;
    private String evaluationFrequency;
    private String filterPattern;
    private String anomalyDetectorStatus;
    private String kmsKeyId;
    private Long creationTimeStamp;
    private Long lastModifiedTimeStamp;
    private Long anomalyVisibilityTime;

    public void setAnomalyDetectorArn(String anomalyDetectorArn) {
        this.anomalyDetectorArn = anomalyDetectorArn;
    }

    public String getAnomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public AnomalyDetector withAnomalyDetectorArn(String anomalyDetectorArn) {
        this.setAnomalyDetectorArn(anomalyDetectorArn);
        return this;
    }

    public void setDetectorName(String detectorName) {
        this.detectorName = detectorName;
    }

    public String getDetectorName() {
        return this.detectorName;
    }

    public AnomalyDetector withDetectorName(String detectorName) {
        this.setDetectorName(detectorName);
        return this;
    }

    public List<String> getLogGroupArnList() {
        if (this.logGroupArnList == null) {
            this.logGroupArnList = new SdkInternalList();
        }
        return this.logGroupArnList;
    }

    public void setLogGroupArnList(Collection<String> logGroupArnList) {
        if (logGroupArnList == null) {
            this.logGroupArnList = null;
            return;
        }
        this.logGroupArnList = new SdkInternalList(logGroupArnList);
    }

    public AnomalyDetector withLogGroupArnList(String ... logGroupArnList) {
        if (this.logGroupArnList == null) {
            this.setLogGroupArnList((Collection<String>)new SdkInternalList(logGroupArnList.length));
        }
        for (String ele : logGroupArnList) {
            this.logGroupArnList.add((Object)ele);
        }
        return this;
    }

    public AnomalyDetector withLogGroupArnList(Collection<String> logGroupArnList) {
        this.setLogGroupArnList(logGroupArnList);
        return this;
    }

    public void setEvaluationFrequency(String evaluationFrequency) {
        this.evaluationFrequency = evaluationFrequency;
    }

    public String getEvaluationFrequency() {
        return this.evaluationFrequency;
    }

    public AnomalyDetector withEvaluationFrequency(String evaluationFrequency) {
        this.setEvaluationFrequency(evaluationFrequency);
        return this;
    }

    public AnomalyDetector withEvaluationFrequency(EvaluationFrequency evaluationFrequency) {
        this.evaluationFrequency = evaluationFrequency.toString();
        return this;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public AnomalyDetector withFilterPattern(String filterPattern) {
        this.setFilterPattern(filterPattern);
        return this;
    }

    public void setAnomalyDetectorStatus(String anomalyDetectorStatus) {
        this.anomalyDetectorStatus = anomalyDetectorStatus;
    }

    public String getAnomalyDetectorStatus() {
        return this.anomalyDetectorStatus;
    }

    public AnomalyDetector withAnomalyDetectorStatus(String anomalyDetectorStatus) {
        this.setAnomalyDetectorStatus(anomalyDetectorStatus);
        return this;
    }

    public AnomalyDetector withAnomalyDetectorStatus(AnomalyDetectorStatus anomalyDetectorStatus) {
        this.anomalyDetectorStatus = anomalyDetectorStatus.toString();
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public AnomalyDetector withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setCreationTimeStamp(Long creationTimeStamp) {
        this.creationTimeStamp = creationTimeStamp;
    }

    public Long getCreationTimeStamp() {
        return this.creationTimeStamp;
    }

    public AnomalyDetector withCreationTimeStamp(Long creationTimeStamp) {
        this.setCreationTimeStamp(creationTimeStamp);
        return this;
    }

    public void setLastModifiedTimeStamp(Long lastModifiedTimeStamp) {
        this.lastModifiedTimeStamp = lastModifiedTimeStamp;
    }

    public Long getLastModifiedTimeStamp() {
        return this.lastModifiedTimeStamp;
    }

    public AnomalyDetector withLastModifiedTimeStamp(Long lastModifiedTimeStamp) {
        this.setLastModifiedTimeStamp(lastModifiedTimeStamp);
        return this;
    }

    public void setAnomalyVisibilityTime(Long anomalyVisibilityTime) {
        this.anomalyVisibilityTime = anomalyVisibilityTime;
    }

    public Long getAnomalyVisibilityTime() {
        return this.anomalyVisibilityTime;
    }

    public AnomalyDetector withAnomalyVisibilityTime(Long anomalyVisibilityTime) {
        this.setAnomalyVisibilityTime(anomalyVisibilityTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAnomalyDetectorArn() != null) {
            sb.append("AnomalyDetectorArn: ").append(this.getAnomalyDetectorArn()).append(",");
        }
        if (this.getDetectorName() != null) {
            sb.append("DetectorName: ").append(this.getDetectorName()).append(",");
        }
        if (this.getLogGroupArnList() != null) {
            sb.append("LogGroupArnList: ").append(this.getLogGroupArnList()).append(",");
        }
        if (this.getEvaluationFrequency() != null) {
            sb.append("EvaluationFrequency: ").append(this.getEvaluationFrequency()).append(",");
        }
        if (this.getFilterPattern() != null) {
            sb.append("FilterPattern: ").append(this.getFilterPattern()).append(",");
        }
        if (this.getAnomalyDetectorStatus() != null) {
            sb.append("AnomalyDetectorStatus: ").append(this.getAnomalyDetectorStatus()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getCreationTimeStamp() != null) {
            sb.append("CreationTimeStamp: ").append(this.getCreationTimeStamp()).append(",");
        }
        if (this.getLastModifiedTimeStamp() != null) {
            sb.append("LastModifiedTimeStamp: ").append(this.getLastModifiedTimeStamp()).append(",");
        }
        if (this.getAnomalyVisibilityTime() != null) {
            sb.append("AnomalyVisibilityTime: ").append(this.getAnomalyVisibilityTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetector)) {
            return false;
        }
        AnomalyDetector other = (AnomalyDetector)obj;
        if (other.getAnomalyDetectorArn() == null ^ this.getAnomalyDetectorArn() == null) {
            return false;
        }
        if (other.getAnomalyDetectorArn() != null && !other.getAnomalyDetectorArn().equals(this.getAnomalyDetectorArn())) {
            return false;
        }
        if (other.getDetectorName() == null ^ this.getDetectorName() == null) {
            return false;
        }
        if (other.getDetectorName() != null && !other.getDetectorName().equals(this.getDetectorName())) {
            return false;
        }
        if (other.getLogGroupArnList() == null ^ this.getLogGroupArnList() == null) {
            return false;
        }
        if (other.getLogGroupArnList() != null && !other.getLogGroupArnList().equals(this.getLogGroupArnList())) {
            return false;
        }
        if (other.getEvaluationFrequency() == null ^ this.getEvaluationFrequency() == null) {
            return false;
        }
        if (other.getEvaluationFrequency() != null && !other.getEvaluationFrequency().equals(this.getEvaluationFrequency())) {
            return false;
        }
        if (other.getFilterPattern() == null ^ this.getFilterPattern() == null) {
            return false;
        }
        if (other.getFilterPattern() != null && !other.getFilterPattern().equals(this.getFilterPattern())) {
            return false;
        }
        if (other.getAnomalyDetectorStatus() == null ^ this.getAnomalyDetectorStatus() == null) {
            return false;
        }
        if (other.getAnomalyDetectorStatus() != null && !other.getAnomalyDetectorStatus().equals(this.getAnomalyDetectorStatus())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getCreationTimeStamp() == null ^ this.getCreationTimeStamp() == null) {
            return false;
        }
        if (other.getCreationTimeStamp() != null && !other.getCreationTimeStamp().equals(this.getCreationTimeStamp())) {
            return false;
        }
        if (other.getLastModifiedTimeStamp() == null ^ this.getLastModifiedTimeStamp() == null) {
            return false;
        }
        if (other.getLastModifiedTimeStamp() != null && !other.getLastModifiedTimeStamp().equals(this.getLastModifiedTimeStamp())) {
            return false;
        }
        if (other.getAnomalyVisibilityTime() == null ^ this.getAnomalyVisibilityTime() == null) {
            return false;
        }
        return other.getAnomalyVisibilityTime() == null || other.getAnomalyVisibilityTime().equals(this.getAnomalyVisibilityTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAnomalyDetectorArn() == null ? 0 : this.getAnomalyDetectorArn().hashCode());
        hashCode = 31 * hashCode + (this.getDetectorName() == null ? 0 : this.getDetectorName().hashCode());
        hashCode = 31 * hashCode + (this.getLogGroupArnList() == null ? 0 : this.getLogGroupArnList().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationFrequency() == null ? 0 : this.getEvaluationFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getFilterPattern() == null ? 0 : this.getFilterPattern().hashCode());
        hashCode = 31 * hashCode + (this.getAnomalyDetectorStatus() == null ? 0 : this.getAnomalyDetectorStatus().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTimeStamp() == null ? 0 : this.getCreationTimeStamp().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTimeStamp() == null ? 0 : this.getLastModifiedTimeStamp().hashCode());
        hashCode = 31 * hashCode + (this.getAnomalyVisibilityTime() == null ? 0 : this.getAnomalyVisibilityTime().hashCode());
        return hashCode;
    }

    public AnomalyDetector clone() {
        try {
            return (AnomalyDetector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnomalyDetectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

