/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.network.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.semconv.ClientAttributes;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.network.internal.AddressAndPort;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;

public final class InternalClientAttributesExtractor<REQUEST> {
    private final AddressAndPortExtractor<REQUEST> addressAndPortExtractor;
    private final boolean capturePort;

    public InternalClientAttributesExtractor(AddressAndPortExtractor<REQUEST> addressAndPortExtractor, boolean capturePort) {
        this.addressAndPortExtractor = addressAndPortExtractor;
        this.capturePort = capturePort;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        AddressAndPort clientAddressAndPort = this.addressAndPortExtractor.extract(request);
        if (clientAddressAndPort.address != null) {
            AttributesExtractorUtil.internalSet(attributes, ClientAttributes.CLIENT_ADDRESS, clientAddressAndPort.address);
            if (this.capturePort && clientAddressAndPort.port != null && clientAddressAndPort.port > 0) {
                AttributesExtractorUtil.internalSet(attributes, ClientAttributes.CLIENT_PORT, Long.valueOf(clientAddressAndPort.port.intValue()));
            }
        }
    }
}

