/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.util.Objects;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.security.token.Token;

public class BlockLocationInfo {
    private final BlockID blockID;
    private long length;
    private final long offset;
    private Token<OzoneBlockTokenIdentifier> token;
    private long createVersion;
    private Pipeline pipeline;
    private int partNumber;

    protected BlockLocationInfo(Builder builder) {
        this.blockID = builder.blockID;
        this.pipeline = builder.pipeline;
        this.length = builder.length;
        this.offset = builder.offset;
        this.token = builder.token;
        this.partNumber = builder.partNumber;
        this.createVersion = builder.createVersion;
    }

    public void setCreateVersion(long version) {
        this.createVersion = version;
    }

    public long getCreateVersion() {
        return this.createVersion;
    }

    public BlockID getBlockID() {
        return this.blockID;
    }

    public long getContainerID() {
        return this.blockID.getContainerID();
    }

    public long getLocalID() {
        return this.blockID.getLocalID();
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getBlockCommitSequenceId() {
        return this.blockID.getBlockCommitSequenceId();
    }

    public Token<OzoneBlockTokenIdentifier> getToken() {
        return this.token;
    }

    public void setToken(Token<OzoneBlockTokenIdentifier> token) {
        this.token = token;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public String toString() {
        return "{blockID={" + this.blockID + "}, length=" + this.length + ", offset=" + this.offset + ", token=" + this.token + ", pipeline=" + this.pipeline + ", createVersion=" + this.createVersion + ", partNumber=" + this.partNumber + '}';
    }

    public boolean hasSameBlockAs(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockLocationInfo that = (BlockLocationInfo)o;
        return this.length == that.length && this.offset == that.offset && this.createVersion == that.createVersion && Objects.equals(this.blockID, that.blockID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockLocationInfo that = (BlockLocationInfo)o;
        return this.length == that.length && this.offset == that.offset && this.createVersion == that.createVersion && Objects.equals(this.blockID, that.blockID) && Objects.equals(this.token, that.token) && Objects.equals(this.pipeline, that.pipeline);
    }

    public int hashCode() {
        return Objects.hash(this.blockID, this.length, this.offset, this.token, this.createVersion, this.pipeline);
    }

    public static class Builder {
        private BlockID blockID;
        private long length;
        private long offset;
        private Token<OzoneBlockTokenIdentifier> token;
        private Pipeline pipeline;
        private int partNumber;
        private long createVersion;

        public Builder setBlockID(BlockID blockId) {
            this.blockID = blockId;
            return this;
        }

        public Builder setPipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public Builder setLength(long len) {
            this.length = len;
            return this;
        }

        public Builder setOffset(long off) {
            this.offset = off;
            return this;
        }

        public Builder setToken(Token<OzoneBlockTokenIdentifier> bToken) {
            this.token = bToken;
            return this;
        }

        public Builder setPartNumber(int partNum) {
            this.partNumber = partNum;
            return this;
        }

        public Builder setCreateVersion(long version) {
            this.createVersion = version;
            return this;
        }

        public BlockLocationInfo build() {
            return new BlockLocationInfo(this);
        }
    }
}

