/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;

public class LegacyHadoopConfigurationSource
implements MutableConfigurationSource {
    private Configuration configuration;

    public LegacyHadoopConfigurationSource(Configuration configuration) {
        this.configuration = configuration;
    }

    public String get(String key) {
        return this.configuration.getRaw(key);
    }

    public char[] getPassword(String key) throws IOException {
        return this.configuration.getPassword(key);
    }

    public Collection<String> getConfigKeys() {
        return this.configuration.getPropsWithPrefix("").keySet();
    }

    public void set(String key, String value) {
        this.configuration.set(key, value);
    }

    public static Configuration asHadoopConfiguration(ConfigurationSource config) {
        if (config instanceof Configuration) {
            return (Configuration)config;
        }
        if (config instanceof LegacyHadoopConfigurationSource) {
            return ((LegacyHadoopConfigurationSource)config).configuration;
        }
        throw new IllegalArgumentException("Core Hadoop code requires real Hadoop configuration");
    }

    public Configuration getOriginalHadoopConfiguration() {
        return this.configuration;
    }
}

