/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.ozone.common.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface UpgradeFinalizer<T> {
    public static final Logger LOG = LoggerFactory.getLogger(UpgradeFinalizer.class);
    public static final StatusAndMessages STARTING_MSG = new StatusAndMessages(Status.STARTING_FINALIZATION, Arrays.asList("Starting Finalization"));
    public static final StatusAndMessages FINALIZATION_IN_PROGRESS_MSG = new StatusAndMessages(Status.FINALIZATION_IN_PROGRESS, Arrays.asList("Finalization in progress"));
    public static final StatusAndMessages FINALIZATION_REQUIRED_MSG = new StatusAndMessages(Status.FINALIZATION_REQUIRED, Arrays.asList("Finalization required"));
    public static final StatusAndMessages FINALIZED_MSG = new StatusAndMessages(Status.ALREADY_FINALIZED, Collections.emptyList());

    public StatusAndMessages finalize(String var1, T var2) throws IOException;

    public void finalizeAndWaitForCompletion(String var1, T var2, long var3) throws IOException;

    public StatusAndMessages reportStatus(String var1, boolean var2) throws IOException;

    public Status getStatus();

    public void runPrefinalizeStateActions(Storage var1, T var2) throws IOException;

    public static class StatusAndMessages {
        private Status status;
        private Collection<String> msgs;

        public StatusAndMessages(Status status, Collection<String> msgs) {
            this.status = status;
            this.msgs = msgs;
        }

        public Status status() {
            return this.status;
        }

        public Collection<String> msgs() {
            return this.msgs;
        }
    }

    public static enum Status {
        ALREADY_FINALIZED,
        STARTING_FINALIZATION,
        FINALIZATION_IN_PROGRESS,
        FINALIZATION_DONE,
        FINALIZATION_REQUIRED;

    }
}

