/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasEntityDef
extends AtlasStructDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_DISPLAY_TEXT_ATTRIBUTE = "displayTextAttribute";
    private Set<String> superTypes;
    private Set<String> subTypes;
    private List<AtlasRelationshipAttributeDef> relationshipAttributeDefs;
    private Map<String, List<AtlasStructDef.AtlasAttributeDef>> businessAttributeDefs;

    public AtlasEntityDef() {
        this((String)null, (String)null, (String)null, (String)null, (List<AtlasStructDef.AtlasAttributeDef>)null, (Set<String>)null, (Map<String, String>)null);
    }

    public AtlasEntityDef(String name) {
        this(name, null, null, null, null, null, null);
    }

    public AtlasEntityDef(String name, String description) {
        this(name, description, null, null, null, null, null);
    }

    public AtlasEntityDef(String name, String description, String typeVersion) {
        this(name, description, typeVersion, null, null, null, null);
    }

    public AtlasEntityDef(String name, String description, String typeVersion, String serviceType) {
        this(name, description, typeVersion, serviceType, null, null, null);
    }

    public AtlasEntityDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs) {
        this(name, description, typeVersion, attributeDefs, (Set<String>)null);
    }

    public AtlasEntityDef(String name, String description, String typeVersion, String serviceType, List<AtlasStructDef.AtlasAttributeDef> attributeDefs) {
        this(name, description, typeVersion, serviceType, attributeDefs, null, null);
    }

    public AtlasEntityDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs, Set<String> superTypes) {
        this(name, description, typeVersion, attributeDefs, superTypes, null);
    }

    public AtlasEntityDef(String name, String description, String typeVersion, String serviceType, List<AtlasStructDef.AtlasAttributeDef> attributeDefs, Set<String> superTypes) {
        this(name, description, typeVersion, serviceType, attributeDefs, superTypes, null);
    }

    public AtlasEntityDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs, Set<String> superTypes, Map<String, String> options) {
        super(TypeCategory.ENTITY, name, description, typeVersion, attributeDefs, options);
        this.setSuperTypes(superTypes);
    }

    public AtlasEntityDef(String name, String description, String typeVersion, String serviceType, List<AtlasStructDef.AtlasAttributeDef> attributeDefs, Set<String> superTypes, Map<String, String> options) {
        super(TypeCategory.ENTITY, name, description, typeVersion, attributeDefs, serviceType, options);
        this.setSuperTypes(superTypes);
    }

    public AtlasEntityDef(AtlasEntityDef other) {
        super(other);
        if (other != null) {
            this.setSuperTypes(other.getSuperTypes());
            this.setSubTypes(other.getSubTypes());
            this.setRelationshipAttributeDefs(other.getRelationshipAttributeDefs());
            this.setBusinessAttributeDefs(other.getBusinessAttributeDefs());
        }
    }

    public Set<String> getSuperTypes() {
        return this.superTypes;
    }

    public void setSuperTypes(Set<String> superTypes) {
        if (superTypes != null && this.superTypes == superTypes) {
            return;
        }
        this.superTypes = CollectionUtils.isEmpty(superTypes) ? new HashSet<String>() : new HashSet<String>(superTypes);
    }

    public Set<String> getSubTypes() {
        return this.subTypes;
    }

    public void setSubTypes(Set<String> subTypes) {
        this.subTypes = subTypes;
    }

    public List<AtlasRelationshipAttributeDef> getRelationshipAttributeDefs() {
        return this.relationshipAttributeDefs;
    }

    public void setRelationshipAttributeDefs(List<AtlasRelationshipAttributeDef> relationshipAttributeDefs) {
        this.relationshipAttributeDefs = relationshipAttributeDefs;
    }

    public Map<String, List<AtlasStructDef.AtlasAttributeDef>> getBusinessAttributeDefs() {
        return this.businessAttributeDefs;
    }

    public void setBusinessAttributeDefs(Map<String, List<AtlasStructDef.AtlasAttributeDef>> businessAttributeDefs) {
        this.businessAttributeDefs = businessAttributeDefs;
    }

    public boolean hasSuperType(String typeName) {
        return AtlasEntityDef.hasSuperType(this.superTypes, typeName);
    }

    public void addSuperType(String typeName) {
        Set<String> s = this.superTypes;
        if (!AtlasEntityDef.hasSuperType(s, typeName)) {
            s = new HashSet<String>(s);
            s.add(typeName);
            this.superTypes = s;
        }
    }

    public void removeSuperType(String typeName) {
        Set<String> s = this.superTypes;
        if (AtlasEntityDef.hasSuperType(s, typeName)) {
            s = new HashSet<String>(s);
            s.remove(typeName);
            this.superTypes = s;
        }
    }

    private static boolean hasSuperType(Set<String> superTypes, String typeName) {
        return superTypes != null && typeName != null && superTypes.contains(typeName);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasEntityDef{");
        super.toString(sb);
        sb.append(", superTypes=[");
        AtlasEntityDef.dumpObjects(this.superTypes, sb);
        sb.append("]");
        sb.append(", relationshipAttributeDefs=[");
        if (CollectionUtils.isNotEmpty(this.relationshipAttributeDefs)) {
            int i = 0;
            for (AtlasRelationshipAttributeDef atlasRelationshipAttributeDef : this.relationshipAttributeDefs) {
                if (i > 0) {
                    sb.append(", ");
                }
                atlasRelationshipAttributeDef.toString(sb);
                ++i;
            }
        }
        sb.append(']');
        sb.append(", businessAttributeDefs={");
        if (MapUtils.isNotEmpty(this.businessAttributeDefs)) {
            int nsIdx = 0;
            for (Map.Entry entry : this.businessAttributeDefs.entrySet()) {
                String nsName = (String)entry.getKey();
                List nsAttrs = (List)entry.getValue();
                if (nsIdx > 0) {
                    sb.append(", ");
                }
                sb.append(nsName).append("=[");
                int attrIdx = 0;
                for (AtlasStructDef.AtlasAttributeDef attributeDef : nsAttrs) {
                    if (attrIdx > 0) {
                        sb.append(", ");
                    }
                    attributeDef.toString(sb);
                    ++attrIdx;
                }
                sb.append(']');
                ++nsIdx;
            }
        }
        sb.append('}');
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasEntityDef that = (AtlasEntityDef)o;
        return Objects.equals(this.superTypes, that.superTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.superTypes);
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasEntityDef.class})
    public static class AtlasEntityDefs
    extends PList<AtlasEntityDef> {
        private static final long serialVersionUID = 1L;

        public AtlasEntityDefs() {
        }

        public AtlasEntityDefs(List<AtlasEntityDef> list) {
            super(list);
        }

        public AtlasEntityDefs(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasRelationshipAttributeDef
    extends AtlasStructDef.AtlasAttributeDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String relationshipTypeName;
        private boolean isLegacyAttribute;

        public AtlasRelationshipAttributeDef() {
        }

        public AtlasRelationshipAttributeDef(String relationshipTypeName, boolean isLegacyAttribute, AtlasStructDef.AtlasAttributeDef attributeDef) {
            super(attributeDef);
            this.relationshipTypeName = relationshipTypeName;
            this.isLegacyAttribute = isLegacyAttribute;
        }

        public String getRelationshipTypeName() {
            return this.relationshipTypeName;
        }

        public void setRelationshipTypeName(String relationshipTypeName) {
            this.relationshipTypeName = relationshipTypeName;
        }

        public boolean getIsLegacyAttribute() {
            return this.isLegacyAttribute;
        }

        public void setIsLegacyAttribute(boolean isLegacyAttribute) {
            this.isLegacyAttribute = isLegacyAttribute;
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasRelationshipAttributeDef{");
            super.toString(sb);
            sb.append(", relationshipTypeName='").append(this.relationshipTypeName).append('\'');
            sb.append(", isLegacyAttribute='").append(this.isLegacyAttribute).append('\'');
            sb.append('}');
            return sb;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtlasRelationshipAttributeDef that = (AtlasRelationshipAttributeDef)o;
            return super.equals(that) && this.isLegacyAttribute == that.isLegacyAttribute && Objects.equals(this.relationshipTypeName, that.relationshipTypeName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.relationshipTypeName, this.isLegacyAttribute);
        }

        @Override
        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }
    }
}

