/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.notification.EntityNotification;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.v1.model.instance.AtlasSystemAttributes;
import org.apache.atlas.v1.model.instance.Id;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.instance.Struct;
import org.apache.atlas.v1.model.notification.EntityNotificationV1;
import org.apache.atlas.v1.model.notification.HookNotificationV1;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasJson {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasJson.class);
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    private static final ObjectMapper mapperV1 = new ObjectMapper().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    private static final ObjectMapper mapperV1Search = new ObjectMapper().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    private static final String V1_KEY_$TYPENAME = "$typeName$";
    private static final String V1_KEY_$ID = "$id$";
    private static final String V1_KEY_$SYSTEM_ATTRIBUTES = "$systemAttributes$";
    private static final String V1_KEY_$TRAITS = "$traits$";
    private static final String V1_KEY_TYPENAME = "typeName";
    private static final String V1_KEY_ID = "id";
    private static final String V1_KEY_GUID = "guid";
    private static final String V1_KEY_SCORE = "score";
    private static final String V1_KEY_VERSION = "version";
    private static final String V1_KEY_STATE = "state";
    private static final String V1_KEY_CREATED_BY = "createdBy";
    private static final String V1_KEY_MODIFIED_BY = "modifiedBy";
    private static final String V1_KEY_CREATED_TIME = "createdTime";
    private static final String V1_KEY_MODIFIED_TIME = "modifiedTime";

    public static String toJson(Object obj) {
        String ret;
        try {
            ret = obj instanceof JsonNode && ((JsonNode)obj).isTextual() ? ((JsonNode)obj).textValue() : mapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            LOG.error("AtlasJson.toJson()", (Throwable)e);
            ret = null;
        }
        return ret;
    }

    public static <T> T fromLinkedHashMap(Object linkedHashMap, Class<T> type) {
        Object ret = null;
        if (linkedHashMap != null && (ret = mapper.convertValue(linkedHashMap, type)) instanceof Struct) {
            ((Struct)ret).normalize();
        }
        return (T)ret;
    }

    public static <T> T fromJson(String jsonStr, Class<T> type) {
        Object ret = null;
        if (jsonStr != null) {
            try {
                ret = mapper.readValue(jsonStr, type);
                if (ret instanceof Struct) {
                    ((Struct)ret).normalize();
                }
            }
            catch (IOException e) {
                LOG.error("AtlasType.fromJson()", (Throwable)e);
                ret = null;
            }
        }
        return (T)ret;
    }

    public static <T> T fromJson(String jsonStr, TypeReference<T> type) {
        Object ret = null;
        if (jsonStr != null) {
            try {
                ret = mapper.readValue(jsonStr, type);
                if (ret instanceof Struct) {
                    ((Struct)ret).normalize();
                }
            }
            catch (IOException e) {
                LOG.error("AtlasType.fromJson()", (Throwable)e);
                ret = null;
            }
        }
        return (T)ret;
    }

    public static <T> T fromJson(InputStream inputStream, Class<T> type) throws IOException {
        Object ret = null;
        if (inputStream != null && (ret = mapper.readValue(inputStream, type)) instanceof Struct) {
            ((Struct)ret).normalize();
        }
        return (T)ret;
    }

    public static String toV1Json(Object obj) {
        return AtlasJson.toJson(obj);
    }

    public static <T> T fromV1Json(String jsonStr, Class<T> type) {
        return AtlasJson.fromJson(jsonStr, type);
    }

    public static <T> T fromV1Json(String jsonStr, TypeReference<T> type) {
        return AtlasJson.fromJson(jsonStr, type);
    }

    public static String toV1SearchJson(Object obj) {
        String ret;
        try {
            ret = mapperV1Search.writeValueAsString(obj);
        }
        catch (IOException e) {
            LOG.error("AtlasType.toV1Json()", (Throwable)e);
            ret = null;
        }
        return ret;
    }

    public static ObjectNode createV1ObjectNode() {
        return mapperV1.createObjectNode();
    }

    public static ObjectNode createV1ObjectNode(String key, Object value) {
        ObjectNode ret = mapperV1.createObjectNode();
        ret.putPOJO(key, value);
        return ret;
    }

    public static ArrayNode createV1ArrayNode() {
        return mapperV1.createArrayNode();
    }

    public static ArrayNode createV1ArrayNode(Collection<?> array) {
        ArrayNode ret = mapper.createArrayNode();
        for (Object elem : array) {
            ret.addPOJO(elem);
        }
        return ret;
    }

    public static JsonNode parseToV1JsonNode(String json) throws IOException {
        JsonNode jsonNode = mapper.readTree(json);
        return jsonNode;
    }

    public static ArrayNode parseToV1ArrayNode(String json) throws IOException {
        JsonNode jsonNode = mapper.readTree(json);
        if (jsonNode instanceof ArrayNode) {
            return (ArrayNode)jsonNode;
        }
        throw new IOException("not an array");
    }

    public static ArrayNode parseToV1ArrayNode(Collection<String> jsonStrings) throws IOException {
        ArrayNode ret = AtlasJson.createV1ArrayNode();
        for (String json : jsonStrings) {
            JsonNode jsonNode = mapper.readTree(json);
            ret.add(jsonNode);
        }
        return ret;
    }

    public static ObjectCodec getMapper() {
        return mapper;
    }

    static {
        SimpleModule atlasSerDeModule = new SimpleModule("AtlasSerDe", new Version(1, 0, 0, null));
        atlasSerDeModule.addSerializer(Referenceable.class, (JsonSerializer)new ReferenceableSerializer());
        atlasSerDeModule.addDeserializer(Referenceable.class, (JsonDeserializer)new ReferenceableDeserializer());
        atlasSerDeModule.addSerializer(Struct.class, (JsonSerializer)new StructSerializer());
        atlasSerDeModule.addDeserializer(Struct.class, (JsonDeserializer)new StructDeserializer());
        atlasSerDeModule.addSerializer(Id.class, (JsonSerializer)new IdSerializer());
        atlasSerDeModule.addDeserializer(Id.class, (JsonDeserializer)new IdDeserializer());
        atlasSerDeModule.addDeserializer(HookNotification.class, (JsonDeserializer)new HookNotificationDeserializer());
        atlasSerDeModule.addDeserializer(EntityNotification.class, (JsonDeserializer)new EntityNotificationDeserializer());
        mapper.registerModule((Module)atlasSerDeModule);
        SimpleModule atlasSerDeV1Module = new SimpleModule("AtlasSerDeV1", new Version(1, 0, 0, null));
        atlasSerDeV1Module.addSerializer(Date.class, (JsonSerializer)new DateSerializer());
        atlasSerDeV1Module.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        mapperV1.registerModule((Module)atlasSerDeV1Module);
        SimpleModule searchResultV1SerDeModule = new SimpleModule("SearchResultV1SerDe", new Version(1, 0, 0, null));
        searchResultV1SerDeModule.addSerializer(Referenceable.class, (JsonSerializer)new V1SearchReferenceableSerializer());
        searchResultV1SerDeModule.addSerializer(Struct.class, (JsonSerializer)new V1SearchStructSerializer());
        searchResultV1SerDeModule.addSerializer(Id.class, (JsonSerializer)new V1SearchIdSerializer());
        searchResultV1SerDeModule.addSerializer(AtlasSystemAttributes.class, (JsonSerializer)new V1SearchSystemAttributesSerializer());
        searchResultV1SerDeModule.addSerializer(AtlasSearchResult.AtlasFullTextResult.class, (JsonSerializer)new V1SearchFullTextResultSerializer());
        searchResultV1SerDeModule.addSerializer(Date.class, (JsonSerializer)new DateSerializer());
        mapperV1Search.registerModule((Module)searchResultV1SerDeModule);
    }

    static class V1SearchFullTextResultSerializer
    extends JsonSerializer<AtlasSearchResult.AtlasFullTextResult> {
        V1SearchFullTextResultSerializer() {
        }

        public void serialize(AtlasSearchResult.AtlasFullTextResult result, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (result != null && result.getEntity() != null) {
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                valueMap.put(AtlasJson.V1_KEY_GUID, result.getEntity().getGuid());
                valueMap.put(AtlasJson.V1_KEY_TYPENAME, result.getEntity().getTypeName());
                valueMap.put(AtlasJson.V1_KEY_SCORE, result.getScore());
                jgen.writeObject(valueMap);
            }
        }
    }

    static class V1SearchSystemAttributesSerializer
    extends JsonSerializer<AtlasSystemAttributes> {
        private static final ThreadLocal<DateFormat> V1_SEARCH_RESULT_DATE_FORMAT = new ThreadLocal<DateFormat>(){

            @Override
            public DateFormat initialValue() {
                SimpleDateFormat ret = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
                return ret;
            }
        };

        V1SearchSystemAttributesSerializer() {
        }

        public void serialize(AtlasSystemAttributes systemAttributes, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (systemAttributes != null) {
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put(AtlasJson.V1_KEY_CREATED_BY, systemAttributes.getCreatedBy());
                valueMap.put(AtlasJson.V1_KEY_MODIFIED_BY, systemAttributes.getModifiedBy());
                if (systemAttributes.getCreatedTime() != null) {
                    valueMap.put(AtlasJson.V1_KEY_CREATED_TIME, V1_SEARCH_RESULT_DATE_FORMAT.get().format(systemAttributes.getCreatedTime()));
                }
                if (systemAttributes.getModifiedTime() != null) {
                    valueMap.put(AtlasJson.V1_KEY_MODIFIED_TIME, V1_SEARCH_RESULT_DATE_FORMAT.get().format(systemAttributes.getModifiedTime()));
                }
                jgen.writeObject(valueMap);
            }
        }
    }

    static class V1SearchIdSerializer
    extends JsonSerializer<Id> {
        V1SearchIdSerializer() {
        }

        public void serialize(Id id, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (id != null) {
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                valueMap.put(AtlasJson.V1_KEY_ID, id._getId());
                valueMap.put(AtlasJson.V1_KEY_$TYPENAME, id.getTypeName());
                valueMap.put(AtlasJson.V1_KEY_VERSION, id.getVersion());
                if (id.getState() != null) {
                    valueMap.put(AtlasJson.V1_KEY_STATE, id.getState().toString());
                }
                jgen.writeObject(valueMap);
            }
        }
    }

    static class V1SearchStructSerializer
    extends JsonSerializer<Struct> {
        V1SearchStructSerializer() {
        }

        public void serialize(Struct struct, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (struct != null) {
                HashMap<String, Object> valueMap = struct.getValues() != null ? new HashMap<String, Object>(struct.getValues()) : new HashMap();
                valueMap.put(AtlasJson.V1_KEY_$TYPENAME, struct.getTypeName());
                jgen.writeObject(valueMap);
            }
        }
    }

    static class V1SearchReferenceableSerializer
    extends JsonSerializer<Referenceable> {
        V1SearchReferenceableSerializer() {
        }

        public void serialize(Referenceable entity, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (entity != null) {
                HashMap<String, Object> valueMap;
                HashMap<String, Object> hashMap = valueMap = entity.getValues() != null ? new HashMap<String, Object>(entity.getValues()) : new HashMap();
                if (entity.getTypeName() != null) {
                    valueMap.put(AtlasJson.V1_KEY_$TYPENAME, entity.getTypeName());
                }
                if (entity.getId() != null) {
                    valueMap.put(AtlasJson.V1_KEY_$ID, entity.getId());
                }
                if (entity.getSystemAttributes() != null) {
                    valueMap.put(AtlasJson.V1_KEY_$SYSTEM_ATTRIBUTES, entity.getSystemAttributes());
                }
                if (MapUtils.isNotEmpty(entity.getTraits())) {
                    valueMap.put(AtlasJson.V1_KEY_$TRAITS, entity.getTraits());
                }
                jgen.writeObject(valueMap);
            }
        }
    }

    static class EntityNotificationDeserializer
    extends JsonDeserializer<EntityNotification> {
        EntityNotificationDeserializer() {
        }

        public EntityNotification deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            EntityNotification.EntityNotificationType notificationType;
            EntityNotification ret = null;
            ObjectCodec mapper = parser.getCodec();
            TreeNode root = mapper.readTree(parser);
            JsonNode typeNode = root != null ? (JsonNode)root.get("type") : null;
            String strType = typeNode != null ? typeNode.asText() : null;
            EntityNotification.EntityNotificationType entityNotificationType = notificationType = strType != null ? EntityNotification.EntityNotificationType.valueOf(strType) : EntityNotification.EntityNotificationType.ENTITY_NOTIFICATION_V1;
            if (root != null) {
                switch (notificationType) {
                    case ENTITY_NOTIFICATION_V1: {
                        ret = (EntityNotification)mapper.treeToValue(root, EntityNotificationV1.class);
                        break;
                    }
                    case ENTITY_NOTIFICATION_V2: {
                        ret = (EntityNotification)mapper.treeToValue(root, EntityNotification.EntityNotificationV2.class);
                    }
                }
            }
            return ret;
        }
    }

    static class HookNotificationDeserializer
    extends JsonDeserializer<HookNotification> {
        HookNotificationDeserializer() {
        }

        public HookNotification deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            HookNotification.HookNotificationType notificationType;
            HookNotification ret = null;
            ObjectCodec mapper = parser.getCodec();
            TreeNode root = mapper.readTree(parser);
            JsonNode typeNode = root != null ? (JsonNode)root.get("type") : null;
            String strType = typeNode != null ? typeNode.asText() : null;
            HookNotification.HookNotificationType hookNotificationType = notificationType = strType != null ? HookNotification.HookNotificationType.valueOf(strType) : null;
            if (notificationType != null) {
                switch (notificationType) {
                    case TYPE_CREATE: 
                    case TYPE_UPDATE: {
                        ret = (HookNotification)mapper.treeToValue(root, HookNotificationV1.TypeRequest.class);
                        break;
                    }
                    case ENTITY_CREATE: {
                        ret = (HookNotification)mapper.treeToValue(root, HookNotificationV1.EntityCreateRequest.class);
                        break;
                    }
                    case ENTITY_PARTIAL_UPDATE: {
                        ret = (HookNotification)mapper.treeToValue(root, HookNotificationV1.EntityPartialUpdateRequest.class);
                        break;
                    }
                    case ENTITY_FULL_UPDATE: {
                        ret = (HookNotification)mapper.treeToValue(root, HookNotificationV1.EntityUpdateRequest.class);
                        break;
                    }
                    case ENTITY_DELETE: {
                        ret = (HookNotification)mapper.treeToValue(root, HookNotificationV1.EntityDeleteRequest.class);
                        break;
                    }
                    case ENTITY_CREATE_V2: {
                        ret = (HookNotification)mapper.treeToValue(root, HookNotification.EntityCreateRequestV2.class);
                        break;
                    }
                    case ENTITY_PARTIAL_UPDATE_V2: {
                        ret = (HookNotification)mapper.treeToValue(root, HookNotification.EntityPartialUpdateRequestV2.class);
                        break;
                    }
                    case ENTITY_FULL_UPDATE_V2: {
                        ret = (HookNotification)mapper.treeToValue(root, HookNotification.EntityUpdateRequestV2.class);
                        break;
                    }
                    case ENTITY_DELETE_V2: {
                        ret = (HookNotification)mapper.treeToValue(root, HookNotification.EntityDeleteRequestV2.class);
                    }
                }
            }
            return ret;
        }
    }

    static class IdDeserializer
    extends JsonDeserializer<Id> {
        IdDeserializer() {
        }

        public Id deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Id ret = (Id)mapperV1.readValue(parser, Id.class);
            return ret;
        }
    }

    static class IdSerializer
    extends JsonSerializer<Id> {
        IdSerializer() {
        }

        public void serialize(Id value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value != null) {
                mapperV1.writeValue(jgen, (Object)value);
            }
        }
    }

    static class StructDeserializer
    extends JsonDeserializer<Struct> {
        StructDeserializer() {
        }

        public Struct deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Struct ret = (Struct)mapperV1.readValue(parser, Struct.class);
            return ret;
        }
    }

    static class StructSerializer
    extends JsonSerializer<Struct> {
        StructSerializer() {
        }

        public void serialize(Struct value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value != null) {
                mapperV1.writeValue(jgen, (Object)value);
            }
        }
    }

    static class ReferenceableDeserializer
    extends JsonDeserializer<Referenceable> {
        ReferenceableDeserializer() {
        }

        public Referenceable deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Referenceable ret = (Referenceable)mapperV1.readValue(parser, Referenceable.class);
            return ret;
        }
    }

    static class ReferenceableSerializer
    extends JsonSerializer<Referenceable> {
        ReferenceableSerializer() {
        }

        public void serialize(Referenceable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value != null) {
                mapperV1.writeValue(jgen, (Object)value);
            }
        }
    }

    static class DateDeserializer
    extends JsonDeserializer<Date> {
        DateDeserializer() {
        }

        public Date deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Date ret = null;
            String value = (String)parser.readValueAs(String.class);
            if (value != null) {
                try {
                    ret = AtlasBaseTypeDef.getDateFormatter().parse(value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return ret;
        }
    }

    static class DateSerializer
    extends JsonSerializer<Date> {
        DateSerializer() {
        }

        public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value != null) {
                jgen.writeString(AtlasBaseTypeDef.getDateFormatter().format(value));
            }
        }
    }
}

