/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.shell.cli.AbstractShell;
import org.apache.ratis.shell.cli.Command;
import org.apache.ratis.shell.cli.sh.command.AbstractParentCommand;
import org.apache.ratis.shell.cli.sh.command.Context;
import org.apache.ratis.shell.cli.sh.command.ElectionCommand;
import org.apache.ratis.shell.cli.sh.command.GroupCommand;
import org.apache.ratis.shell.cli.sh.command.LocalCommand;
import org.apache.ratis.shell.cli.sh.command.PeerCommand;
import org.apache.ratis.shell.cli.sh.command.SnapshotCommand;

public class RatisShell
extends AbstractShell {
    static final List<Function<Context, AbstractParentCommand>> PARENT_COMMAND_CONSTRUCTORS = Collections.unmodifiableList(Arrays.asList(PeerCommand::new, GroupCommand::new, ElectionCommand::new, SnapshotCommand::new, LocalCommand::new));

    static List<AbstractParentCommand> allParentCommands(Context context) {
        return PARENT_COMMAND_CONSTRUCTORS.stream().map(constructor -> (AbstractParentCommand)constructor.apply(context)).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        RatisShell shell = new RatisShell(System.out);
        System.exit(shell.run(args));
    }

    public RatisShell(PrintStream out) {
        this(new Context(out));
    }

    private RatisShell(Context context) {
        super(context);
    }

    @Override
    protected String getShellName() {
        return "sh";
    }

    @Override
    protected Map<String, Command> loadCommands(Context context) {
        return RatisShell.allParentCommands(context).stream().collect(Collectors.toMap(Command::getCommandName, Function.identity()));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private PrintStream printStream = System.out;
        private RetryPolicy retryPolicy;
        private RaftProperties properties;
        private Parameters parameters;

        public Builder setPrintStream(PrintStream printStream) {
            this.printStream = printStream;
            return this;
        }

        public Builder setRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder setProperties(RaftProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder setParameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public RatisShell build() {
            return new RatisShell(new Context(this.printStream, false, this.retryPolicy, this.properties, this.parameters));
        }
    }
}

