/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.api.DataStreamOutput;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.examples.filestore.FileStoreCommon;
import org.apache.ratis.proto.ExamplesProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RoutingTable;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreClient
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(FileStoreClient.class);
    private final RaftClient client;

    public FileStoreClient(RaftGroup group, RaftProperties properties) throws IOException {
        this.client = RaftClient.newBuilder().setProperties(properties).setRaftGroup(group).build();
    }

    public FileStoreClient(RaftGroup group, RaftProperties properties, RaftPeer primaryDataStreamServer) throws IOException {
        this.client = RaftClient.newBuilder().setProperties(properties).setRaftGroup(group).setPrimaryDataStreamServer(primaryDataStreamServer).build();
    }

    public FileStoreClient(RaftClient client) {
        this.client = client;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    static ByteString send(Message request, CheckedFunction<Message, RaftClientReply, IOException> sendFunction) throws IOException {
        RaftClientReply reply = sendFunction.apply(request);
        StateMachineException sme = reply.getStateMachineException();
        if (sme != null) {
            throw new IOException("Failed to send request " + request, sme);
        }
        Preconditions.assertTrue(reply.isSuccess(), () -> "Failed " + request + ", reply=" + reply);
        return reply.getMessage().getContent();
    }

    static CompletableFuture<ByteString> sendAsync(Message request, Function<Message, CompletableFuture<RaftClientReply>> sendFunction) {
        return sendFunction.apply(request).thenApply(reply -> {
            StateMachineException sme = reply.getStateMachineException();
            if (sme != null) {
                throw new CompletionException("Failed to send request " + request, sme);
            }
            Preconditions.assertTrue(reply.isSuccess(), () -> "Failed " + request + ", reply=" + reply);
            return reply.getMessage().getContent();
        });
    }

    private ByteString send(Message request) throws IOException {
        return FileStoreClient.send(request, this.client.io()::send);
    }

    private ByteString sendReadOnly(Message request) throws IOException {
        return FileStoreClient.send(request, this.client.io()::sendReadOnly);
    }

    private CompletableFuture<ByteString> sendAsync(Message request) {
        return FileStoreClient.sendAsync(request, this.client.async()::send);
    }

    private CompletableFuture<ByteString> sendReadOnlyAsync(Message request) {
        return FileStoreClient.sendAsync(request, this.client.async()::sendReadOnly);
    }

    public ByteString read(String path, long offset, long length) throws IOException {
        ByteString reply = FileStoreClient.readImpl(this::sendReadOnly, path, offset, length);
        return ExamplesProtos.ReadReplyProto.parseFrom(reply).getData();
    }

    public CompletableFuture<ByteString> readAsync(String path, long offset, long length) {
        return FileStoreClient.readImpl(this::sendReadOnlyAsync, path, offset, length).thenApply(reply -> JavaUtils.supplyAndWrapAsCompletionException(() -> ExamplesProtos.ReadReplyProto.parseFrom(reply).getData()));
    }

    private static <OUTPUT, THROWABLE extends Throwable> OUTPUT readImpl(CheckedFunction<Message, OUTPUT, THROWABLE> sendReadOnlyFunction, String path, long offset, long length) throws THROWABLE {
        ExamplesProtos.ReadRequestProto read = ExamplesProtos.ReadRequestProto.newBuilder().setPath(ProtoUtils.toByteString(path)).setOffset(offset).setLength(length).build();
        return sendReadOnlyFunction.apply(Message.valueOf(read));
    }

    private CompletableFuture<ByteString> sendWatchAsync(Message request) {
        return FileStoreClient.sendAsync(request, this.client.async()::sendReadOnlyUnordered);
    }

    public CompletableFuture<ExamplesProtos.ReadReplyProto> watchAsync(String path) {
        return FileStoreClient.watchImpl(this::sendWatchAsync, path).thenApply(reply -> JavaUtils.supplyAndWrapAsCompletionException(() -> ExamplesProtos.ReadReplyProto.parseFrom(reply)));
    }

    private static <OUTPUT, THROWABLE extends Throwable> OUTPUT watchImpl(CheckedFunction<Message, OUTPUT, THROWABLE> sendWatchFunction, String path) throws THROWABLE {
        ExamplesProtos.ReadRequestProto watch = ExamplesProtos.ReadRequestProto.newBuilder().setPath(ProtoUtils.toByteString(path)).setIsWatch(true).build();
        return sendWatchFunction.apply(Message.valueOf(watch));
    }

    public long write(String path, long offset, boolean close, ByteBuffer buffer, boolean sync) throws IOException {
        int chunkSize = FileStoreCommon.getChunkSize(buffer.remaining());
        buffer.limit(chunkSize);
        ByteString reply = FileStoreClient.writeImpl(this::send, path, offset, close, buffer, sync);
        return ExamplesProtos.WriteReplyProto.parseFrom(reply).getLength();
    }

    public DataStreamOutput getStreamOutput(String path, long dataSize, RoutingTable routingTable) {
        ExamplesProtos.StreamWriteRequestProto header = ExamplesProtos.StreamWriteRequestProto.newBuilder().setPath(ProtoUtils.toByteString(path)).setLength(dataSize).build();
        ExamplesProtos.FileStoreRequestProto request = ExamplesProtos.FileStoreRequestProto.newBuilder().setStream(header).build();
        return this.client.getDataStreamApi().stream(request.toByteString().asReadOnlyByteBuffer(), routingTable);
    }

    public CompletableFuture<Long> writeAsync(String path, long offset, boolean close, ByteBuffer buffer, boolean sync) {
        return FileStoreClient.writeImpl(this::sendAsync, path, offset, close, buffer, sync).thenApply(reply -> JavaUtils.supplyAndWrapAsCompletionException(() -> ExamplesProtos.WriteReplyProto.parseFrom(reply).getLength()));
    }

    private static <OUTPUT, THROWABLE extends Throwable> OUTPUT writeImpl(CheckedFunction<Message, OUTPUT, THROWABLE> sendFunction, String path, long offset, boolean close, ByteBuffer data, boolean sync) throws THROWABLE {
        ExamplesProtos.WriteRequestHeaderProto.Builder header = ExamplesProtos.WriteRequestHeaderProto.newBuilder().setPath(ProtoUtils.toByteString(path)).setOffset(offset).setLength(data.remaining()).setClose(close).setSync(sync);
        ExamplesProtos.WriteRequestProto.Builder write = ExamplesProtos.WriteRequestProto.newBuilder().setHeader(header).setData(ByteString.copyFrom(data));
        ExamplesProtos.FileStoreRequestProto request = ExamplesProtos.FileStoreRequestProto.newBuilder().setWrite(write).build();
        return sendFunction.apply(Message.valueOf(request));
    }

    private static <OUTPUT, THROWABLE extends Throwable> OUTPUT deleteImpl(CheckedFunction<Message, OUTPUT, THROWABLE> sendFunction, String path) throws THROWABLE {
        ExamplesProtos.DeleteRequestProto.Builder delete = ExamplesProtos.DeleteRequestProto.newBuilder().setPath(ProtoUtils.toByteString(path));
        ExamplesProtos.FileStoreRequestProto request = ExamplesProtos.FileStoreRequestProto.newBuilder().setDelete(delete).build();
        return sendFunction.apply(Message.valueOf(request));
    }

    public String delete(String path) throws IOException {
        ByteString reply = FileStoreClient.deleteImpl(this::send, path);
        return ExamplesProtos.DeleteReplyProto.parseFrom(reply).getResolvedPath().toStringUtf8();
    }

    public CompletableFuture<String> deleteAsync(String path) {
        return FileStoreClient.deleteImpl(this::sendAsync, path).thenApply(reply -> JavaUtils.supplyAndWrapAsCompletionException(() -> ExamplesProtos.DeleteReplyProto.parseFrom(reply).getResolvedPath().toStringUtf8()));
    }
}

