/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.function.LongSupplier;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;
import org.apache.ratis.metrics.Timekeeper;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.raftlog.RaftLogIndex;
import org.apache.ratis.statemachine.StateMachine;

public final class StateMachineMetrics
extends RatisMetrics {
    public static final String RATIS_STATEMACHINE_METRICS = "state_machine";
    public static final String RATIS_STATEMACHINE_METRICS_DESC = "Metrics for State Machine Updater";
    public static final String STATEMACHINE_APPLIED_INDEX_GAUGE = "appliedIndex";
    public static final String STATEMACHINE_APPLY_COMPLETED_GAUGE = "applyCompletedIndex";
    public static final String STATEMACHINE_TAKE_SNAPSHOT_TIMER = "takeSnapshot";
    private final Timekeeper takeSnapshotTimer = this.getRegistry().timer("takeSnapshot");

    public static StateMachineMetrics getStateMachineMetrics(RaftServerImpl server, RaftLogIndex appliedIndex, StateMachine stateMachine) {
        String serverId = server.getMemberId().toString();
        LongSupplier getApplied = appliedIndex::get;
        LongSupplier getApplyCompleted = () -> stateMachine.getLastAppliedTermIndex() == null ? -1L : stateMachine.getLastAppliedTermIndex().getIndex();
        return new StateMachineMetrics(serverId, getApplied, getApplyCompleted);
    }

    private StateMachineMetrics(String serverId, LongSupplier getApplied, LongSupplier getApplyCompleted) {
        super(StateMachineMetrics.createRegistry(serverId));
        this.getRegistry().gauge(STATEMACHINE_APPLIED_INDEX_GAUGE, () -> getApplied::getAsLong);
        this.getRegistry().gauge(STATEMACHINE_APPLY_COMPLETED_GAUGE, () -> getApplyCompleted::getAsLong);
    }

    private static RatisMetricRegistry createRegistry(String serverId) {
        return StateMachineMetrics.create(new MetricRegistryInfo(serverId, "ratis", RATIS_STATEMACHINE_METRICS, RATIS_STATEMACHINE_METRICS_DESC));
    }

    public Timekeeper getTakeSnapshotTimer() {
        return this.takeSnapshotTimer;
    }
}

