/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.adapter;

import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.apache.seatunnel.app.interceptor.AuthenticationInterceptor;
import org.apache.seatunnel.app.resolver.UserIdMethodArgumentResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;

@Configuration
public class SeatunnelWebAdapter
implements WebMvcConfigurer {
    public static final String LOCALE_LANGUAGE_COOKIE = "language";
    public static final String LOGIN_INTERCEPTOR_PATH_PATTERN = "/**/*";
    public static final String LOGIN_PATH_PATTERN = "/seatunnel/api/v1/user/login**";
    public static final String REGISTER_PATH_PATTERN = "/users/register";
    @Resource
    private UserIdMethodArgumentResolver currentUserMethodArgumentResolver;

    @Bean
    public AuthenticationInterceptor authenticationInterceptor() {
        return new AuthenticationInterceptor();
    }

    @Bean(name={"localeResolver"})
    public LocaleResolver localeResolver() {
        CookieLocaleResolver localeResolver = new CookieLocaleResolver();
        localeResolver.setCookieName(LOCALE_LANGUAGE_COOKIE);
        localeResolver.setDefaultLocale(Locale.US);
        localeResolver.setLanguageTagCompliant(false);
        return localeResolver;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.authenticationInterceptor()).order(1).addPathPatterns(new String[]{LOGIN_INTERCEPTOR_PATH_PATTERN}).excludePathPatterns(new String[]{LOGIN_PATH_PATTERN, REGISTER_PATH_PATTERN, "/swagger-resources/**", "/webjars/**", "/v2/**", "*.html", "/ui/**", "/error", "/swagger-ui.html**"});
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(this.currentUserMethodArgumentResolver);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(new String[]{"classpath:/static/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        registry.addResourceHandler(new String[]{"/ui/**"}).addResourceLocations(new String[]{"file:ui/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("redirect:/ui/");
        registry.addViewController("/ui/").setViewName("forward:/ui/index.html");
    }
}

