/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource.impl;

import com.google.auto.service.AutoService;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.datasource.AbstractDataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.impl.KafkaKingbaseDataSourceConfigSwitcher;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;

@AutoService(value={DataSourceConfigSwitcher.class})
public class KafkaDataSourceConfigSwitcher
extends AbstractDataSourceConfigSwitcher {
    private static final String SCHEMA = "schema";
    private static final String TOPIC = "topic";
    private static final String TABLE = "table";
    private static final String FORMAT = "format";
    private static final String DEBEZIUM_FORMAT = "COMPATIBLE_DEBEZIUM_JSON";

    @Override
    public String getDataSourceName() {
        return "KAFKA";
    }

    @Override
    public FormStructure filterOptionRule(String connectorName, OptionRule dataSourceOptionRule, OptionRule virtualTableOptionRule, BusinessMode businessMode, PluginType pluginType, OptionRule connectorOptionRule, List<RequiredOption> addRequiredOptions, List<Option<?>> addOptionalOptions, List<String> excludedKeys) {
        if (pluginType == PluginType.SOURCE) {
            excludedKeys.add(SCHEMA);
            excludedKeys.add(TOPIC);
        }
        if (pluginType == PluginType.SINK && businessMode.equals((Object)BusinessMode.DATA_REPLICA)) {
            excludedKeys.add(FORMAT);
        }
        return super.filterOptionRule(connectorName, dataSourceOptionRule, virtualTableOptionRule, businessMode, pluginType, connectorOptionRule, addRequiredOptions, addOptionalOptions, excludedKeys);
    }

    @Override
    public Config mergeDatasourceConfig(Config dataSourceInstanceConfig, VirtualTableDetailRes virtualTableDetail, DataSourceOption dataSourceOption, SelectTableFields selectTableFields, BusinessMode businessMode, PluginType pluginType, Config connectorConfig) {
        if (pluginType == PluginType.SOURCE) {
            connectorConfig = connectorConfig.withValue(TOPIC, ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(TOPIC)));
            connectorConfig = connectorConfig.withValue(SCHEMA, (ConfigValue)KafkaKingbaseDataSourceConfigSwitcher.SchemaGenerator.generateSchemaBySelectTableFields(virtualTableDetail, selectTableFields).root());
        } else if (pluginType == PluginType.SINK) {
            if (businessMode.equals((Object)BusinessMode.DATA_INTEGRATION)) {
                connectorConfig = connectorConfig.withValue(TOPIC, ConfigValueFactory.fromAnyRef((Object)virtualTableDetail.getDatasourceProperties().get(TOPIC)));
            }
            if (businessMode.equals((Object)BusinessMode.DATA_REPLICA)) {
                connectorConfig = connectorConfig.withValue(FORMAT, ConfigValueFactory.fromAnyRef((Object)DEBEZIUM_FORMAT));
            }
        } else {
            throw new UnsupportedOperationException("Unsupported plugin type: " + pluginType);
        }
        return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
    }
}

