/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource.impl;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.impl.BaseJdbcDataSourceConfigSwitcher;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;

@AutoService(value={DataSourceConfigSwitcher.class})
public class TidbDataSourceConfigSwitcher
extends BaseJdbcDataSourceConfigSwitcher {
    private static final String FACTORY = "factory";
    private static final String CATALOG = "catalog";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String BASE_URL = "base-url";
    private static final String TABLE_NAMES = "table-names";
    private static final String DATABASE_NAMES = "database-names";

    @Override
    public String getDataSourceName() {
        return "JDBC-TIDB";
    }

    @Override
    public Config mergeDatasourceConfig(Config dataSourceInstanceConfig, VirtualTableDetailRes virtualTableDetail, DataSourceOption dataSourceOption, SelectTableFields selectTableFields, BusinessMode businessMode, PluginType pluginType, Config connectorConfig) {
        Config config = ConfigFactory.empty();
        config = config.withValue(FACTORY, ConfigValueFactory.fromAnyRef((Object)"TiDB"));
        config = config.withValue(USERNAME, ConfigValueFactory.fromAnyRef((Object)dataSourceInstanceConfig.getString("user")));
        config = config.withValue(PASSWORD, ConfigValueFactory.fromAnyRef((Object)dataSourceInstanceConfig.getString(PASSWORD)));
        config = config.withValue(BASE_URL, ConfigValueFactory.fromAnyRef((Object)dataSourceInstanceConfig.getString("url")));
        connectorConfig = connectorConfig.withValue(CATALOG, (ConfigValue)config.root());
        return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
    }
}

