/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.job;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.client.SeaTunnelHazelcastClient;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.Job;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobResult;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelCancelJobCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelGetJobStatusCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelSubmitJobCodec;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelWaitForJobCompleteCodec;

public class ClientJobProxy
implements Job {
    private static final ILogger LOGGER = Logger.getLogger(ClientJobProxy.class);
    private final SeaTunnelHazelcastClient seaTunnelHazelcastClient;
    private final Long jobId;
    private JobResult jobResult;

    public ClientJobProxy(@NonNull SeaTunnelHazelcastClient seaTunnelHazelcastClient, @NonNull JobImmutableInformation jobImmutableInformation) {
        if (seaTunnelHazelcastClient == null) {
            throw new NullPointerException("seaTunnelHazelcastClient is marked non-null but is null");
        }
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked non-null but is null");
        }
        this.seaTunnelHazelcastClient = seaTunnelHazelcastClient;
        this.jobId = jobImmutableInformation.getJobId();
        this.submitJob(jobImmutableInformation);
    }

    public ClientJobProxy(@NonNull SeaTunnelHazelcastClient seaTunnelHazelcastClient, Long jobId) {
        if (seaTunnelHazelcastClient == null) {
            throw new NullPointerException("seaTunnelHazelcastClient is marked non-null but is null");
        }
        this.seaTunnelHazelcastClient = seaTunnelHazelcastClient;
        this.jobId = jobId;
    }

    public long getJobId() {
        return this.jobId;
    }

    private void submitJob(JobImmutableInformation jobImmutableInformation) {
        LOGGER.info(String.format("Start submit job, job id: %s, with plugin jar %s", jobImmutableInformation.getJobId(), jobImmutableInformation.getPluginJarsUrls()));
        ClientMessage request = SeaTunnelSubmitJobCodec.encodeRequest((long)jobImmutableInformation.getJobId(), (Data)this.seaTunnelHazelcastClient.getSerializationService().toData((Object)jobImmutableInformation));
        PassiveCompletableFuture<Void> submitJobFuture = this.seaTunnelHazelcastClient.requestOnMasterAndGetCompletableFuture(request);
        submitJobFuture.join();
        LOGGER.info(String.format("Submit job finished, job id: %s, job name: %s", jobImmutableInformation.getJobId(), jobImmutableInformation.getJobName()));
    }

    public JobStatus waitForJobComplete() {
        try {
            this.jobResult = (JobResult)RetryUtils.retryWithException(() -> {
                PassiveCompletableFuture<JobResult> jobFuture = this.doWaitForJobComplete();
                return (JobResult)jobFuture.get();
            }, (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(100000, true, exception -> ExceptionUtil.isOperationNeedRetryException((Throwable)exception), 2000L));
            if (this.jobResult == null) {
                throw new SeaTunnelEngineException("failed to fetch job result");
            }
        }
        catch (Exception e) {
            LOGGER.info(String.format("Job (%s) end with unknown state, and throw Exception: %s", this.jobId, ExceptionUtils.getMessage((Throwable)e)));
            throw new RuntimeException(e);
        }
        LOGGER.info(String.format("Job (%s) end with state %s", this.jobId, this.jobResult.getStatus()));
        if (StringUtils.isNotEmpty((CharSequence)this.jobResult.getError()) || this.jobResult.getStatus().equals((Object)JobStatus.FAILED)) {
            throw new SeaTunnelEngineException(this.jobResult.getError());
        }
        return this.jobResult.getStatus();
    }

    public JobResult getJobResultCache() {
        return this.jobResult;
    }

    public PassiveCompletableFuture<JobResult> doWaitForJobComplete() {
        return new PassiveCompletableFuture(this.seaTunnelHazelcastClient.requestOnMasterAndGetCompletableFuture(SeaTunnelWaitForJobCompleteCodec.encodeRequest((long)this.jobId), SeaTunnelWaitForJobCompleteCodec::decodeResponse).thenApply(jobResult -> (JobResult)this.seaTunnelHazelcastClient.getSerializationService().toObject(jobResult)));
    }

    public void cancelJob() {
        PassiveCompletableFuture<Void> cancelFuture = this.seaTunnelHazelcastClient.requestOnMasterAndGetCompletableFuture(SeaTunnelCancelJobCodec.encodeRequest((long)this.jobId));
        cancelFuture.join();
    }

    public JobStatus getJobStatus() {
        int jobStatusOrdinal = (Integer)this.seaTunnelHazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelGetJobStatusCodec.encodeRequest((long)this.jobId), SeaTunnelGetJobStatusCodec::decodeResponse);
        return JobStatus.values()[jobStatusOrdinal];
    }
}

