/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelDependencyProvider;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelProvider;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="default")
public class DefaultModelProvider
implements ModelProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultModelProvider.class);
    private final TypeResolver resolver;
    private final ModelPropertiesProvider propertiesProvider;
    private final ModelDependencyProvider dependencyProvider;
    private final SchemaPluginsManager schemaPluginsManager;
    private final TypeNameExtractor typeNameExtractor;

    @Autowired
    public DefaultModelProvider(TypeResolver resolver, @Qualifier(value="cachedModelProperties") ModelPropertiesProvider propertiesProvider, @Qualifier(value="cachedModelDependencies") ModelDependencyProvider dependencyProvider, SchemaPluginsManager schemaPluginsManager, TypeNameExtractor typeNameExtractor) {
        this.resolver = resolver;
        this.propertiesProvider = propertiesProvider;
        this.dependencyProvider = dependencyProvider;
        this.schemaPluginsManager = schemaPluginsManager;
        this.typeNameExtractor = typeNameExtractor;
    }

    @Override
    public Optional<Model> modelFor(ModelContext modelContext) {
        ResolvedType propertiesHost = modelContext.alternateFor(modelContext.resolvedType(this.resolver));
        if (Collections.isContainerType(propertiesHost) || Maps.isMapType(propertiesHost) || propertiesHost.getErasedType().isEnum() || Types.isBaseType(propertiesHost) || modelContext.hasSeenBefore(propertiesHost)) {
            LOG.debug("Skipping model of type {} as its either a container type, map, enum or base type, or its already been handled", ResolvedTypes.resolvedTypeSignature(propertiesHost).or((Object)"<null>"));
            return Optional.absent();
        }
        ImmutableMap propertiesIndex = com.google.common.collect.Maps.uniqueIndex(this.properties(modelContext, propertiesHost), this.byPropertyName());
        LOG.debug("Inferred {} properties. Properties found {}", (Object)propertiesIndex.size(), (Object)Joiner.on((String)", ").join((Iterable)propertiesIndex.keySet()));
        TreeMap properties = com.google.common.collect.Maps.newTreeMap();
        properties.putAll(propertiesIndex);
        return Optional.of((Object)this.modelBuilder(propertiesHost, properties, modelContext));
    }

    private Model modelBuilder(ResolvedType propertiesHost, Map<String, ModelProperty> properties, ModelContext modelContext) {
        String typeName = this.typeNameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)propertiesHost));
        modelContext.getBuilder().id(typeName).type(propertiesHost).name(typeName).qualifiedType(ResolvedTypes.simpleQualifiedTypeName(propertiesHost)).properties(properties).description("").baseModel("").discriminator("").subTypes(new ArrayList());
        return this.schemaPluginsManager.model(modelContext);
    }

    @Override
    public Map<String, Model> dependencies(ModelContext modelContext) {
        HashMap models = com.google.common.collect.Maps.newHashMap();
        for (ResolvedType resolvedType : this.dependencyProvider.dependentModels(modelContext)) {
            ModelContext parentContext = ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)resolvedType);
            Optional model = this.modelFor(parentContext).or(this.mapModel(parentContext, resolvedType));
            if (!model.isPresent()) continue;
            models.put(((Model)model.get()).getName(), model.get());
        }
        return models;
    }

    private Optional<Model> mapModel(ModelContext parentContext, ResolvedType resolvedType) {
        if (Maps.isMapType(resolvedType) && !parentContext.hasSeenBefore(resolvedType)) {
            String typeName = this.typeNameExtractor.typeName(parentContext);
            return Optional.of((Object)parentContext.getBuilder().id(typeName).type(resolvedType).name(typeName).qualifiedType(ResolvedTypes.simpleQualifiedTypeName(resolvedType)).properties(new HashMap()).description("").baseModel("").discriminator("").subTypes(new ArrayList()).build());
        }
        return Optional.absent();
    }

    private Function<ModelProperty, String> byPropertyName() {
        return new Function<ModelProperty, String>(){

            public String apply(ModelProperty input) {
                return input.getName();
            }
        };
    }

    private List<ModelProperty> properties(ModelContext context, ResolvedType propertiesHost) {
        return this.propertiesProvider.propertiesFor(propertiesHost, context);
    }
}

