/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.google.common.base.Optional;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PojoPropertyBuilderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(POJOPropertyBuilder.class);

    PojoPropertyBuilderFactory() {
    }

    POJOPropertyBuilder create(MapperConfig<?> config, BeanPropertyDefinition beanProperty) {
        boolean forSerialization;
        AnnotationIntrospector annotationIntrospector = config.isAnnotationProcessingEnabled() ? config.getAnnotationIntrospector() : null;
        Optional<POJOPropertyBuilder> instance = this.jackson26Instance(beanProperty, annotationIntrospector, forSerialization = config instanceof SerializationConfig);
        if (!instance.isPresent()) {
            return this.jackson27Instance(config, beanProperty, annotationIntrospector, forSerialization);
        }
        return (POJOPropertyBuilder)instance.get();
    }

    private POJOPropertyBuilder jackson27Instance(MapperConfig<?> config, BeanPropertyDefinition beanProperty, AnnotationIntrospector annotationIntrospector, boolean forSerialization) {
        try {
            Constructor<POJOPropertyBuilder> constructor = this.constructorWithParams(MapperConfig.class, AnnotationIntrospector.class, Boolean.TYPE, PropertyName.class);
            return constructor.newInstance(config, annotationIntrospector, forSerialization, new PropertyName(beanProperty.getName()));
        }
        catch (Exception e) {
            throw new InstantiationError("Unable to create an instance of POJOPropertyBuilder");
        }
    }

    private Optional<POJOPropertyBuilder> jackson26Instance(BeanPropertyDefinition beanProperty, AnnotationIntrospector annotationIntrospector, boolean forSerialization) {
        try {
            Constructor<POJOPropertyBuilder> constructor = this.constructorWithParams(PropertyName.class, AnnotationIntrospector.class, Boolean.TYPE);
            return Optional.of((Object)constructor.newInstance(new PropertyName(beanProperty.getName()), annotationIntrospector, forSerialization));
        }
        catch (Exception e) {
            LOG.debug("Unable to instantiate jackson 26 object", (Throwable)e);
            return Optional.absent();
        }
    }

    private Constructor<POJOPropertyBuilder> constructorWithParams(Class<?> ... clazzes) throws NoSuchMethodException {
        return POJOPropertyBuilder.class.getConstructor(clazzes);
    }
}

