/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.dag.actions;

import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.engine.core.dag.actions.Config;
import org.apache.seatunnel.engine.core.dag.actions.ShuffleStrategy;

public class ShuffleConfig
implements Config {
    public static final int DEFAULT_BATCH_SIZE = 1024;
    public static final long DEFAULT_BATCH_FLUSH_INTERVAL = TimeUnit.SECONDS.toMillis(3L);
    private int batchSize;
    private long batchFlushInterval;
    private ShuffleStrategy shuffleStrategy;

    public ShuffleConfig() {
    }

    private static int $default$batchSize() {
        return 1024;
    }

    private static long $default$batchFlushInterval() {
        return DEFAULT_BATCH_FLUSH_INTERVAL;
    }

    ShuffleConfig(int batchSize, long batchFlushInterval, ShuffleStrategy shuffleStrategy) {
        this.batchSize = batchSize;
        this.batchFlushInterval = batchFlushInterval;
        this.shuffleStrategy = shuffleStrategy;
    }

    public static ShuffleConfigBuilder builder() {
        return new ShuffleConfigBuilder();
    }

    public ShuffleConfigBuilder toBuilder() {
        return new ShuffleConfigBuilder().batchSize(this.batchSize).batchFlushInterval(this.batchFlushInterval).shuffleStrategy(this.shuffleStrategy);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getBatchFlushInterval() {
        return this.batchFlushInterval;
    }

    public ShuffleStrategy getShuffleStrategy() {
        return this.shuffleStrategy;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchFlushInterval(long batchFlushInterval) {
        this.batchFlushInterval = batchFlushInterval;
    }

    public void setShuffleStrategy(ShuffleStrategy shuffleStrategy) {
        this.shuffleStrategy = shuffleStrategy;
    }

    public String toString() {
        return "ShuffleConfig(batchSize=" + this.getBatchSize() + ", batchFlushInterval=" + this.getBatchFlushInterval() + ", shuffleStrategy=" + this.getShuffleStrategy() + ")";
    }

    public static class ShuffleConfigBuilder {
        private boolean batchSize$set;
        private int batchSize$value;
        private boolean batchFlushInterval$set;
        private long batchFlushInterval$value;
        private ShuffleStrategy shuffleStrategy;

        ShuffleConfigBuilder() {
        }

        public ShuffleConfigBuilder batchSize(int batchSize) {
            this.batchSize$value = batchSize;
            this.batchSize$set = true;
            return this;
        }

        public ShuffleConfigBuilder batchFlushInterval(long batchFlushInterval) {
            this.batchFlushInterval$value = batchFlushInterval;
            this.batchFlushInterval$set = true;
            return this;
        }

        public ShuffleConfigBuilder shuffleStrategy(ShuffleStrategy shuffleStrategy) {
            this.shuffleStrategy = shuffleStrategy;
            return this;
        }

        public ShuffleConfig build() {
            int batchSize$value = this.batchSize$value;
            if (!this.batchSize$set) {
                batchSize$value = ShuffleConfig.$default$batchSize();
            }
            long batchFlushInterval$value = this.batchFlushInterval$value;
            if (!this.batchFlushInterval$set) {
                batchFlushInterval$value = ShuffleConfig.$default$batchFlushInterval();
            }
            return new ShuffleConfig(batchSize$value, batchFlushInterval$value, this.shuffleStrategy);
        }

        public String toString() {
            return "ShuffleConfig.ShuffleConfigBuilder(batchSize$value=" + this.batchSize$value + ", batchFlushInterval$value=" + this.batchFlushInterval$value + ", shuffleStrategy=" + this.shuffleStrategy + ")";
        }
    }
}

