/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.dag.logical;

import com.google.common.base.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;
import lombok.NonNull;
import org.apache.seatunnel.engine.core.dag.logical.LogicalVertex;
import org.apache.seatunnel.engine.core.serializable.JobDataSerializerHook;

public class LogicalEdge
implements IdentifiedDataSerializable {
    private LogicalVertex inputVertex;
    private LogicalVertex targetVertex;
    private Long inputVertexId;
    private Long targetVertexId;

    public LogicalEdge() {
    }

    public LogicalEdge(LogicalVertex inputVertex, LogicalVertex targetVertex) {
        this.inputVertex = inputVertex;
        this.targetVertex = targetVertex;
        this.inputVertexId = inputVertex.getVertexId();
        this.targetVertexId = targetVertex.getVertexId();
    }

    public void recoveryFromVertexMap(@NonNull Map<Long, LogicalVertex> vertexMap) {
        if (vertexMap == null) {
            throw new NullPointerException("vertexMap is marked non-null but is null");
        }
        this.inputVertex = vertexMap.get(this.inputVertexId);
        this.targetVertex = vertexMap.get(this.targetVertexId);
        Preconditions.checkNotNull((Object)this.inputVertex);
        Preconditions.checkNotNull((Object)this.targetVertex);
    }

    public int getFactoryId() {
        return JobDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 2;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.inputVertexId.longValue());
        out.writeLong(this.targetVertexId.longValue());
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.inputVertexId = in.readLong();
        this.targetVertexId = in.readLong();
    }

    public LogicalVertex getInputVertex() {
        return this.inputVertex;
    }

    public LogicalVertex getTargetVertex() {
        return this.targetVertex;
    }

    public Long getInputVertexId() {
        return this.inputVertexId;
    }

    public Long getTargetVertexId() {
        return this.targetVertexId;
    }

    public void setInputVertex(LogicalVertex inputVertex) {
        this.inputVertex = inputVertex;
    }

    public void setTargetVertex(LogicalVertex targetVertex) {
        this.targetVertex = targetVertex;
    }

    public void setInputVertexId(Long inputVertexId) {
        this.inputVertexId = inputVertexId;
    }

    public void setTargetVertexId(Long targetVertexId) {
        this.targetVertexId = targetVertexId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogicalEdge)) {
            return false;
        }
        LogicalEdge other = (LogicalEdge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$inputVertexId = this.getInputVertexId();
        Long other$inputVertexId = other.getInputVertexId();
        if (this$inputVertexId == null ? other$inputVertexId != null : !((Object)this$inputVertexId).equals(other$inputVertexId)) {
            return false;
        }
        Long this$targetVertexId = this.getTargetVertexId();
        Long other$targetVertexId = other.getTargetVertexId();
        if (this$targetVertexId == null ? other$targetVertexId != null : !((Object)this$targetVertexId).equals(other$targetVertexId)) {
            return false;
        }
        LogicalVertex this$inputVertex = this.getInputVertex();
        LogicalVertex other$inputVertex = other.getInputVertex();
        if (this$inputVertex == null ? other$inputVertex != null : !((Object)this$inputVertex).equals(other$inputVertex)) {
            return false;
        }
        LogicalVertex this$targetVertex = this.getTargetVertex();
        LogicalVertex other$targetVertex = other.getTargetVertex();
        return !(this$targetVertex == null ? other$targetVertex != null : !((Object)this$targetVertex).equals(other$targetVertex));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogicalEdge;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $inputVertexId = this.getInputVertexId();
        result = result * 59 + ($inputVertexId == null ? 43 : ((Object)$inputVertexId).hashCode());
        Long $targetVertexId = this.getTargetVertexId();
        result = result * 59 + ($targetVertexId == null ? 43 : ((Object)$targetVertexId).hashCode());
        LogicalVertex $inputVertex = this.getInputVertex();
        result = result * 59 + ($inputVertex == null ? 43 : ((Object)$inputVertex).hashCode());
        LogicalVertex $targetVertex = this.getTargetVertex();
        result = result * 59 + ($targetVertex == null ? 43 : ((Object)$targetVertex).hashCode());
        return result;
    }

    public String toString() {
        return "LogicalEdge(inputVertex=" + this.getInputVertex() + ", targetVertex=" + this.getTargetVertex() + ", inputVertexId=" + this.getInputVertexId() + ", targetVertexId=" + this.getTargetVertexId() + ")";
    }
}

