/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.common;

import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.transform.common.CommonOptions;
import org.apache.seatunnel.transform.common.ErrorHandleWay;
import org.apache.seatunnel.transform.exception.ErrorDataTransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCatalogSupportTransform
implements SeaTunnelTransform<SeaTunnelRow> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCatalogSupportTransform.class);
    protected final ErrorHandleWay rowErrorHandleWay;
    protected CatalogTable inputCatalogTable;
    protected volatile CatalogTable outputCatalogTable;

    public AbstractCatalogSupportTransform(@NonNull CatalogTable inputCatalogTable) {
        this(inputCatalogTable, (ErrorHandleWay)((Object)CommonOptions.ROW_ERROR_HANDLE_WAY_OPTION.defaultValue()));
        if (inputCatalogTable == null) {
            throw new NullPointerException("inputCatalogTable is marked non-null but is null");
        }
    }

    public AbstractCatalogSupportTransform(@NonNull CatalogTable inputCatalogTable, ErrorHandleWay rowErrorHandleWay) {
        if (inputCatalogTable == null) {
            throw new NullPointerException("inputCatalogTable is marked non-null but is null");
        }
        this.inputCatalogTable = inputCatalogTable;
        this.rowErrorHandleWay = rowErrorHandleWay;
    }

    public SeaTunnelRow map(SeaTunnelRow row) {
        try {
            return this.transformRow(row);
        }
        catch (ErrorDataTransformException e) {
            if (e.getErrorHandleWay() != null) {
                ErrorHandleWay errorHandleWay = e.getErrorHandleWay();
                if (errorHandleWay.allowSkipThisRow()) {
                    log.debug("Skip row due to error", (Throwable)((Object)e));
                    return null;
                }
                throw e;
            }
            if (this.rowErrorHandleWay.allowSkip()) {
                log.debug("Skip row due to error", (Throwable)((Object)e));
                return null;
            }
            throw e;
        }
    }

    protected abstract SeaTunnelRow transformRow(SeaTunnelRow var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CatalogTable getProducedCatalogTable() {
        if (this.outputCatalogTable == null) {
            AbstractCatalogSupportTransform abstractCatalogSupportTransform = this;
            synchronized (abstractCatalogSupportTransform) {
                if (this.outputCatalogTable == null) {
                    this.outputCatalogTable = this.transformCatalogTable();
                }
            }
        }
        return this.outputCatalogTable;
    }

    private CatalogTable transformCatalogTable() {
        TableIdentifier tableIdentifier = this.transformTableIdentifier();
        TableSchema tableSchema = this.transformTableSchema();
        return CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)tableSchema, (Map)this.inputCatalogTable.getOptions(), (List)this.inputCatalogTable.getPartitionKeys(), (String)this.inputCatalogTable.getComment());
    }

    protected abstract TableSchema transformTableSchema();

    protected abstract TableIdentifier transformTableIdentifier();
}

