/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.override;

import com.hazelcast.internal.util.StringUtil;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

class SystemPropertiesConfigParser {
    private final String prefix;
    private final String rootNode;

    SystemPropertiesConfigParser(String prefix, String rootNode) {
        this.prefix = prefix;
        this.rootNode = rootNode;
    }

    static SystemPropertiesConfigParser client() {
        return new SystemPropertiesConfigParser("hz-client.", "hazelcast-client");
    }

    static SystemPropertiesConfigParser member() {
        return new SystemPropertiesConfigParser("hz.", "hazelcast");
    }

    Map<String, String> parse(Properties properties) {
        return properties.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), (String)e.getValue())).filter(e -> ((String)e.getKey()).startsWith(this.prefix)).collect(Collectors.toMap(this::processKey, Map.Entry::getValue));
    }

    private String processKey(AbstractMap.SimpleEntry<String, String> e) {
        return StringUtil.lowerCaseInternal(e.getKey().replace(" ", "").replaceFirst(this.prefix, this.rootNode + "."));
    }
}

