/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.accumulator;

public class LongAccumulator {
    private long value;

    public LongAccumulator() {
    }

    public LongAccumulator(long value) {
        this.value = value;
    }

    public long get() {
        return this.value;
    }

    public LongAccumulator set(long value) {
        this.value = value;
        return this;
    }

    public LongAccumulator add(long value) {
        this.value = Math.addExact(this.value, value);
        return this;
    }

    public LongAccumulator add(LongAccumulator that) {
        this.value = Math.addExact(this.value, that.value);
        return this;
    }

    public LongAccumulator subtract(long value) {
        this.value = Math.subtractExact(this.value, value);
        return this;
    }

    public LongAccumulator subtract(LongAccumulator that) {
        this.value = Math.subtractExact(this.value, that.value);
        return this;
    }

    public LongAccumulator addAllowingOverflow(long value) {
        this.value += value;
        return this;
    }

    public LongAccumulator addAllowingOverflow(LongAccumulator that) {
        this.value += that.value;
        return this;
    }

    public LongAccumulator subtractAllowingOverflow(long value) {
        this.value -= value;
        return this;
    }

    public LongAccumulator subtractAllowingOverflow(LongAccumulator that) {
        this.value -= that.value;
        return this;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.value == ((LongAccumulator)o).value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public String toString() {
        return "LongAccumulator(" + this.value + ')';
    }
}

